/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.clearcut.ClearcutLogger;
import com.google.android.gms.internal.firebase-perf.zzaw;
import com.google.android.gms.internal.firebase-perf.zzbk;
import com.google.android.gms.internal.firebase-perf.zzbl;
import com.google.android.gms.internal.firebase-perf.zzbp;
import com.google.android.gms.internal.firebase-perf.zzbr;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzch;
import com.google.android.gms.internal.firebase-perf.zzcn;
import com.google.android.gms.internal.firebase-perf.zzcy;
import com.google.android.gms.internal.firebase-perf.zzdg;
import com.google.android.gms.internal.firebase-perf.zzep;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.perf.FirebasePerformance;
import com.google.firebase.perf.internal.FeatureControl;
import com.google.firebase.perf.internal.RemoteConfigManager;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zza;
import com.google.firebase.perf.internal.zzc;
import com.google.firebase.perf.internal.zze;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.internal.zzg;
import com.google.firebase.perf.internal.zzh;
import com.google.firebase.perf.internal.zzi;
import com.google.firebase.perf.internal.zzj;
import com.google.firebase.perf.internal.zzk;
import com.google.firebase.perf.internal.zzl;
import com.google.firebase.perf.internal.zzq;
import com.google.firebase.perf.internal.zzv;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class zzd {
    @SuppressLint(value={"StaticFieldLeak"})
    private static zzd zzco;
    private final ExecutorService zzcp;
    private FirebaseApp zzcq;
    private FirebasePerformance zzcr;
    private FirebaseInstanceId zzcs;
    private Context zzct;
    private ClearcutLogger zzcu;
    private String zzcv;
    private final zzbp.zza zzcw = zzbp.zzdq();
    private zzv zzcx;
    private zza zzcy;
    private FeatureControl zzcz;
    private boolean zzda;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static zzd zzbc() {
        if (zzco != null) return zzco;
        Class<zzd> clazz = zzd.class;
        synchronized (zzd.class) {
            if (zzco != null) return zzco;
            try {
                FirebaseApp.getInstance();
            }
            catch (IllegalStateException illegalStateException) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            zzco = new zzd(null, null, null, null, null, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzco;
        }
    }

    @VisibleForTesting(otherwise=2)
    private zzd(@Nullable ExecutorService executorService, @Nullable ClearcutLogger clearcutLogger, @Nullable zzv zzv2, @Nullable zza zza2, @Nullable FirebaseInstanceId firebaseInstanceId, @Nullable FeatureControl featureControl) {
        this.zzcp = executorService = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.zzcu = null;
        this.zzcx = null;
        this.zzcy = null;
        this.zzcs = null;
        this.zzcz = null;
        this.zzcp.execute(new zze(this));
    }

    public final void zza(@NonNull zzcy zzcy2, zzbr zzbr2) {
        this.zzcp.execute(new zzf(this, zzcy2, zzbr2));
        SessionManager.zzcn().zzcq();
    }

    public final void zza(@NonNull zzch zzch2, zzbr zzbr2) {
        this.zzcp.execute(new zzg(this, zzch2, zzbr2));
        SessionManager.zzcn().zzcq();
    }

    public final void zza(zzcb zzcb2, zzbr zzbr2) {
        this.zzcp.execute(new zzh(this, zzcb2, zzbr2));
        SessionManager.zzcn().zzcq();
    }

    public final void zzb(boolean bl) {
        this.zzcp.execute(new zzi(this, bl));
    }

    @WorkerThread
    private final void zzbd() {
        this.zzcq = FirebaseApp.getInstance();
        this.zzcr = FirebasePerformance.getInstance();
        this.zzct = this.zzcq.getApplicationContext();
        this.zzcv = this.zzcq.getOptions().getApplicationId();
        this.zzcw.zzv(this.zzcv).zzb(zzbl.zzdf().zzq(this.zzct.getPackageName()).zzr("1.0.0.225053256").zzs(zzd.zzd(this.zzct)));
        this.zzbe();
        if (this.zzcu == null) {
            try {
                this.zzcu = ClearcutLogger.anonymousLogger((Context)this.zzct, (String)"FIREPERF");
            }
            catch (SecurityException securityException) {
                String string = String.valueOf(securityException.getMessage());
                Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Caught SecurityException while init ClearcutLogger: ".concat(string) : new String("Caught SecurityException while init ClearcutLogger: ")));
                this.zzcu = null;
            }
        }
        RemoteConfigManager.zzcb().zzcd();
        this.zzcx = this.zzcx == null ? new zzv(this.zzct, this.zzcv, 100L, 500L) : this.zzcx;
        this.zzcy = this.zzcy == null ? zza.zzak() : this.zzcy;
        this.zzcz = this.zzcz == null ? FeatureControl.zzar() : this.zzcz;
        this.zzda = zzbk.zzf(this.zzct);
    }

    @WorkerThread
    private final void zza(@NonNull zzcn zzcn2) {
        if (this.zzcu == null) {
            return;
        }
        if (this.zzcr.isPerformanceCollectionEnabled()) {
            boolean bl;
            block20: {
                ArrayList<zzq> arrayList;
                if (!zzcn2.zzfl().zzdl()) {
                    Log.w((String)"FirebasePerformance", (String)"App Instance ID is null or empty, dropping the log");
                    return;
                }
                Context context = this.zzct;
                zzcn zzcn3 = zzcn2;
                Context context2 = context;
                zzcn zzcn4 = zzcn3;
                ArrayList<zzq> arrayList2 = new ArrayList<zzq>();
                if (zzcn4.zzfm()) {
                    arrayList2.add(new zzl(zzcn4.zzfn()));
                }
                if (zzcn4.zzfo()) {
                    arrayList2.add(new zzk(zzcn4.zzfp(), context2));
                }
                if (zzcn4.zzfk()) {
                    arrayList2.add(new zzc(zzcn4.zzfl()));
                }
                if (zzcn4.zzfq()) {
                    arrayList2.add(new zzj(zzcn4.zzfr()));
                }
                if ((arrayList = arrayList2).isEmpty()) {
                    Log.d((String)"FirebasePerformance", (String)"No validators found for PerfMetric.");
                    bl = false;
                } else {
                    ArrayList<zzq> arrayList3 = arrayList;
                    int n = arrayList3.size();
                    Object var8_11 = null;
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList3.get(i);
                        if (((zzq)e).zzbb()) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                Log.w((String)"FirebasePerformance", (String)"Unable to process the PerfMetric due to missing or invalid values. See earlier log statements for additional information on the specific missing/invalid values.");
                return;
            }
            if (!this.zzcx.zzb(zzcn2)) {
                zzcn zzcn5 = zzcn2;
                zzd zzd2 = this;
                if (zzcn5.zzfo()) {
                    zzd2.zzcy.zza(zzaw.zzho.toString(), 1L);
                } else if (zzcn5.zzfm()) {
                    zzd2.zzcy.zza(zzaw.zzhn.toString(), 1L);
                }
                if (this.zzda) {
                    if (zzcn2.zzfo()) {
                        String string = String.valueOf(zzcn2.zzfp().getUrl());
                        Log.i((String)"FirebasePerformance", (String)(string.length() != 0 ? "Rate Limited NetworkRequestMetric - ".concat(string) : new String("Rate Limited NetworkRequestMetric - ")));
                        return;
                    }
                    if (zzcn2.zzfm()) {
                        String string = String.valueOf(zzcn2.zzfn().getName());
                        Log.i((String)"FirebasePerformance", (String)(string.length() != 0 ? "Rate Limited TraceMetric - ".concat(string) : new String("Rate Limited TraceMetric - ")));
                    }
                }
                return;
            }
            byte[] byArray = zzcn2.toByteArray();
            try {
                this.zzcu.newEvent(byArray).log();
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    @WorkerThread
    private final void zzb(zzcb zzcb2, zzbr zzbr2) {
        if (this.zzcr.isPerformanceCollectionEnabled()) {
            if (this.zzda) {
                int n = zzcb2.zzef();
                int n2 = zzcb2.zzeg();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging GaugeMetric. Cpu Metrics: %d, Memory Metrics: %d, Has Metadata: %b, Session ID: %s", n, n2, zzcb2.zzed(), zzcb2.zzec()));
            }
            if (!this.zzcz.zzas()) {
                if (this.zzda) {
                    Log.d((String)"FirebasePerformance", (String)"Sessions are disabled. Not logging GaugeMetric.");
                }
                return;
            }
            zzcn.zza zza2 = zzcn.zzfs();
            this.zzbe();
            zza2.zzb(this.zzcw.zzf(zzbr2)).zzb(zzcb2);
            this.zza((zzcn)((zzep)zza2.zzhy()));
        }
    }

    @WorkerThread
    private final void zzb(@NonNull zzcy zzcy2, zzbr zzbr2) {
        if (this.zzcr.isPerformanceCollectionEnabled()) {
            if (this.zzda) {
                long l = zzcy2.getDurationUs();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging TraceMetric - %s %dms", zzcy2.getName(), l / 1000L));
            }
            if (!this.zzcz.zzas()) {
                zzcy2 = (zzcy)((zzep)((zzcy.zza)((zzep.zza)zzcy2.zzhp())).zzgf().zzhy());
                if (this.zzda) {
                    Log.d((String)"FirebasePerformance", (String)String.format("Sessions are disabled. Dropping all sessions from Trace - %s", zzcy2.getName()));
                }
            }
            this.zzbe();
            zzcn zzcn2 = (zzcn)((zzep)zzcn.zzfs().zzb(((zzbp.zza)((zzep.zza)((zzdg)this.zzcw).clone())).zzf(zzbr2).zzc(this.zzcr.getAttributes())).zzb(zzcy2).zzhy());
            this.zza(zzcn2);
        }
    }

    @WorkerThread
    private final void zzb(@NonNull zzch zzch2, zzbr zzbr2) {
        if (this.zzcr.isPerformanceCollectionEnabled()) {
            if (this.zzda) {
                long l = !zzch2.zzfa() ? 0L : zzch2.zzfb();
                long l2 = !zzch2.zzeq() ? 0L : zzch2.zzer();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging NetworkRequestMetric - %s %db %dms,", zzch2.getUrl(), l2, l / 1000L));
            }
            if (!this.zzcz.zzas()) {
                zzch2 = (zzch)((zzep)((zzch.zza)((zzep.zza)zzch2.zzhp())).zzfj().zzhy());
                if (this.zzda) {
                    Log.d((String)"FirebasePerformance", (String)String.format("Sessions are disabled. Dropping all sessions from Network Request - %s", zzch2.getUrl()));
                }
            }
            this.zzbe();
            zzcn zzcn2 = (zzcn)((zzep)zzcn.zzfs().zzb(this.zzcw.zzf(zzbr2)).zze(zzch2).zzhy());
            this.zza(zzcn2);
        }
    }

    @WorkerThread
    public final void zzc(boolean bl) {
        this.zzcx.zzb(bl);
    }

    private static String zzd(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    @WorkerThread
    private final void zzbe() {
        if (this.zzcw.zzdl()) {
            return;
        }
        if (this.zzcr.isPerformanceCollectionEnabled()) {
            String string;
            if (this.zzcs == null) {
                this.zzcs = FirebaseInstanceId.getInstance();
            }
            if ((string = this.zzcs.getId()) != null && !string.isEmpty()) {
                this.zzcw.zzw(string);
            }
        }
    }

    static /* synthetic */ void zzb(zzd zzd2) {
        zzd2.zzbd();
    }

    static /* synthetic */ void zza(zzd zzd2, zzcy zzcy2, zzbr zzbr2) {
        zzd2.zzb(zzcy2, zzbr2);
    }

    static /* synthetic */ void zza(zzd zzd2, zzch zzch2, zzbr zzbr2) {
        zzd2.zzb(zzch2, zzbr2);
    }

    static /* synthetic */ void zza(zzd zzd2, zzcb zzcb2, zzbr zzbr2) {
        zzd2.zzb(zzcb2, zzbr2);
    }
}

