/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzan;
import com.google.android.gms.internal.firebase-perf.zzaq;
import com.google.android.gms.internal.firebase-perf.zzbr;
import com.google.android.gms.internal.firebase-perf.zzbz;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzep;
import com.google.firebase.perf.internal.FeatureControl;
import com.google.firebase.perf.internal.zzd;
import com.google.firebase.perf.internal.zzm;
import com.google.firebase.perf.internal.zzn;
import com.google.firebase.perf.internal.zzp;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Keep
public class GaugeManager {
    @Nullable
    private static GaugeManager zzdk = null;
    private final ScheduledExecutorService zzdl;
    private final zzd zzdm;
    private final FeatureControl zzcz;
    private final zzp zzdn;
    private final zzan zzdo;
    private final zzaq zzdp;
    private zzbr zzdq = zzbr.zzjj;
    @Nullable
    private String zzdr = null;
    @Nullable
    private ScheduledFuture zzds = null;

    private GaugeManager() {
        this(Executors.newSingleThreadScheduledExecutor(), zzd.zzbc(), FeatureControl.zzar(), zzp.zzbj(), zzan.zzt(), zzaq.zzaa());
    }

    @VisibleForTesting
    private GaugeManager(ScheduledExecutorService scheduledExecutorService, zzd zzd2, FeatureControl featureControl, zzp zzp2, zzan zzan2, zzaq zzaq2) {
        this.zzdl = scheduledExecutorService;
        this.zzdm = zzd2;
        this.zzcz = featureControl;
        this.zzdn = zzp2;
        this.zzdo = zzan2;
        this.zzdp = zzaq2;
    }

    public static synchronized GaugeManager zzbf() {
        if (zzdk == null) {
            zzdk = new GaugeManager();
        }
        return zzdk;
    }

    public final void zza(String string, zzbr zzbr2) {
        long l;
        boolean bl;
        long l2;
        boolean bl2;
        long l3;
        long l4;
        if (this.zzdr != null) {
            this.zzbg();
        }
        zzbr zzbr3 = zzbr2;
        GaugeManager gaugeManager = this;
        long l5 = -1L;
        zzbr zzbr4 = zzbr3;
        GaugeManager gaugeManager2 = gaugeManager;
        switch (zzbr4) {
            case zzjl: {
                l4 = gaugeManager2.zzcz.zzay();
                break;
            }
            case zzjk: {
                l4 = gaugeManager2.zzcz.zzaw();
                break;
            }
            default: {
                l4 = -1L;
            }
        }
        long l6 = l3 = l4 == -1L || l4 <= 0L ? -1L : l4;
        gaugeManager2 = gaugeManager;
        if (!gaugeManager2.zzcz.zzat()) {
            Log.d((String)"FirebasePerformance", (String)"Cpu Metrics collection is disabled. Did not collect Cpu Metrics.");
            bl2 = false;
        } else if (l6 == -1L) {
            Log.d((String)"FirebasePerformance", (String)"Invalid Cpu Metrics collection frequency. Did not collect Cpu Metrics.");
            bl2 = false;
        } else {
            gaugeManager2.zzdo.zzb(l6);
            bl2 = true;
        }
        if (bl2) {
            l5 = l3;
        }
        zzbr zzbr5 = zzbr3;
        gaugeManager2 = gaugeManager;
        switch (zzbr5) {
            case zzjl: {
                l4 = gaugeManager2.zzcz.zzaz();
                break;
            }
            case zzjk: {
                l4 = gaugeManager2.zzcz.zzax();
                break;
            }
            default: {
                l4 = -1L;
            }
        }
        long l7 = l2 = l4 == -1L || l4 <= 0L ? -1L : l4;
        gaugeManager2 = gaugeManager;
        if (!gaugeManager2.zzcz.zzau()) {
            Log.d((String)"FirebasePerformance", (String)"Memory Metrics collection is disabled. Did not collect Memory Metrics.");
            bl = false;
        } else if (l7 == -1L) {
            Log.d((String)"FirebasePerformance", (String)"Invalid Memory Metrics collection frequency. Did not collect Memory Metrics.");
            bl = false;
        } else {
            gaugeManager2.zzdp.zzb(l7);
            bl = true;
        }
        if (bl) {
            long l8 = l5 = l5 == -1L ? l2 : Math.min(l5, l2);
        }
        if ((l = l5) == -1L) {
            Log.w((String)"FirebasePerformance", (String)"Invalid gauge collection frequency. Unable to start collecting Gauges.");
            return;
        }
        this.zzdr = string;
        this.zzdq = zzbr2;
        String string2 = string;
        zzbr zzbr6 = zzbr2;
        try {
            this.zzds = this.zzdl.scheduleAtFixedRate(new zzm(this, string2, zzbr6), l * 20L, l * 20L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            String string3 = String.valueOf(rejectedExecutionException.getMessage());
            Log.w((String)"FirebasePerformance", (String)(string3.length() != 0 ? "Unable to start collecting Gauges: ".concat(string3) : new String("Unable to start collecting Gauges: ")));
            return;
        }
    }

    public final void zzbg() {
        if (this.zzdr == null) {
            return;
        }
        String string = this.zzdr;
        zzbr zzbr2 = this.zzdq;
        this.zzdo.zzu();
        this.zzdp.zzu();
        if (this.zzds != null) {
            this.zzds.cancel(false);
        }
        this.zzdl.schedule(new zzn(this, string, zzbr2), 20L, TimeUnit.MILLISECONDS);
        this.zzdr = null;
        this.zzdq = zzbr.zzjj;
    }

    private final void zzb(String string, zzbr zzbr2) {
        zzcb.zza zza2 = zzcb.zzeh();
        while (!this.zzdo.zzba.isEmpty()) {
            zza2.zzb(this.zzdo.zzba.poll());
        }
        while (!this.zzdp.zzbe.isEmpty()) {
            zza2.zzb(this.zzdp.zzbe.poll());
        }
        zza2.zzaa(string);
        this.zzdm.zza((zzcb)((zzep)zza2.zzhy()), zzbr2);
    }

    final void zzc(String string, zzbr zzbr2) {
        GaugeManager gaugeManager = this;
        zzcb zzcb2 = (zzcb)((zzep)zzcb.zzeh().zzaa(string).zzb((zzbz)((zzep)zzbz.zzdy().zzy(gaugeManager.zzdn.getProcessName()).zzi(gaugeManager.zzdn.zzbm()).zzj(gaugeManager.zzdn.zzbk()).zzk(gaugeManager.zzdn.zzbl()).zzhy())).zzhy());
        this.zzdm.zza(zzcb2, zzbr2);
    }

    public final void zzbh() {
        GaugeManager.zza(this.zzcz.zzat(), this.zzcz.zzau(), this.zzdo, this.zzdp);
    }

    public static void zzbi() {
        GaugeManager.zza(true, true, zzan.zzt(), zzaq.zzaa());
    }

    private static void zza(boolean bl, boolean bl2, zzan zzan2, zzaq zzaq2) {
        if (bl) {
            zzan2.zzv();
        } else {
            Log.d((String)"FirebasePerformance", (String)"Cpu Metrics collection is disabled. Did not collect Cpu Metric.");
        }
        if (bl2) {
            zzaq2.zzv();
            return;
        }
        Log.d((String)"FirebasePerformance", (String)"Memory Metrics collection is disabled. Did not collect Memory Metric.");
    }

    final /* synthetic */ void zzd(String string, zzbr zzbr2) {
        this.zzb(string, zzbr2);
    }

    final /* synthetic */ void zze(String string, zzbr zzbr2) {
        this.zzb(string, zzbr2);
    }
}

