/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzay;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.internal.zzd;
import com.google.firebase.perf.metrics.HttpMetric;
import com.google.firebase.perf.metrics.Trace;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FirebasePerformance {
    public static final int MAX_TRACE_NAME_LENGTH = 100;
    private static volatile FirebasePerformance zzao;
    private final Map<String, String> zzap = new ConcurrentHashMap<String, String>();
    private final zzay zzaq;
    @Nullable
    private Boolean zzar = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebasePerformance getInstance() {
        if (zzao != null) return zzao;
        Class<FirebasePerformance> clazz = FirebasePerformance.class;
        synchronized (FirebasePerformance.class) {
            if (zzao != null) return zzao;
            zzao = (FirebasePerformance)FirebaseApp.getInstance().get(FirebasePerformance.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzao;
        }
    }

    public FirebasePerformance(FirebaseApp firebaseApp) {
        if (firebaseApp == null) {
            this.zzar = false;
            this.zzaq = new zzay(new Bundle());
            return;
        }
        Context context = firebaseApp.getApplicationContext();
        this.zzaq = FirebasePerformance.zzb(context);
        this.zzar = this.zza(context);
    }

    @NonNull
    public static Trace startTrace(@NonNull String string) {
        Trace trace = Trace.zzi(string);
        trace.start();
        return trace;
    }

    public void setPerformanceCollectionEnabled(boolean bl) {
        SharedPreferences sharedPreferences;
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        SharedPreferences sharedPreferences2 = sharedPreferences = FirebaseApp.getInstance().getApplicationContext().getSharedPreferences("FirebasePerfSharedPrefs", 0);
        FirebasePerformance firebasePerformance = this;
        if (!firebasePerformance.zzs()) {
            sharedPreferences2.edit().putBoolean("isEnabled", bl).apply();
            firebasePerformance.zzar = bl;
            if (bl) {
                Log.i((String)"FirebasePerformance", (String)"Firebase Performance is Enabled");
                return;
            }
            Log.i((String)"FirebasePerformance", (String)"Firebase Performance is Disabled");
            return;
        }
        Log.i((String)"FirebasePerformance", (String)"Firebase Performance is permanently disabled");
    }

    public boolean isPerformanceCollectionEnabled() {
        if (this.zzar != null) {
            return this.zzar;
        }
        return FirebaseApp.getInstance().isDataCollectionDefaultEnabled();
    }

    @NonNull
    public final Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzap);
    }

    public final zzay zzr() {
        return this.zzaq;
    }

    @Nullable
    private final Boolean zza(@NonNull Context context) {
        if (this.zzs()) {
            return false;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("FirebasePerfSharedPrefs", 0);
        try {
            if (sharedPreferences.contains("isEnabled")) {
                return sharedPreferences.getBoolean("isEnabled", true);
            }
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            Log.d((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to access enable value: ".concat(string) : new String("Unable to access enable value: ")));
        }
        FirebasePerformance firebasePerformance = this;
        if (firebasePerformance.zzaq.containsKey("firebase_performance_collection_enabled")) {
            return firebasePerformance.zzaq.getBoolean("firebase_performance_collection_enabled", true);
        }
        Log.d((String)"isEnabled", (String)"No perf enable meta data found in manifest.");
        return null;
    }

    @NonNull
    public Trace newTrace(@NonNull String string) {
        return Trace.zzi(string);
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull String string, String string2) {
        return new HttpMetric(string, string2, zzd.zzbc(), new zzbg());
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull URL uRL, String string) {
        return new HttpMetric(uRL, string, zzd.zzbc(), new zzbg());
    }

    private final boolean zzs() {
        return this.zzaq.getBoolean("firebase_performance_collection_deactivated", false);
    }

    private static zzay zzb(Context context) {
        Bundle bundle = null;
        try {
            bundle = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            String string = String.valueOf(throwable.getMessage());
            Log.d((String)"isEnabled", (String)(string.length() != 0 ? "No perf enable meta data found ".concat(string) : new String("No perf enable meta data found ")));
        }
        if (bundle != null) {
            return new zzay(bundle);
        }
        return new zzay();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpMethod {
        public static final String GET = "GET";
        public static final String PUT = "PUT";
        public static final String POST = "POST";
        public static final String DELETE = "DELETE";
        public static final String HEAD = "HEAD";
        public static final String PATCH = "PATCH";
        public static final String OPTIONS = "OPTIONS";
        public static final String TRACE = "TRACE";
        public static final String CONNECT = "CONNECT";
    }
}

