/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import java.util.Map;

public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    final int mVersionCode;
    Bundle bI;
    private Map<String, String> zzctd;
    private Notification baR;

    RemoteMessage(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.bI = bundle;
    }

    RemoteMessage(Bundle bundle) {
        this(1, bundle);
    }

    void zzaf(Intent intent) {
        intent.putExtras(this.bI);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.bI.getString("from");
    }

    public String getTo() {
        return this.bI.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzctd == null) {
            this.zzctd = new ArrayMap();
            for (String string : this.bI.keySet()) {
                Object object = this.bI.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.zzctd.put(string, string2);
            }
        }
        return this.zzctd;
    }

    public String getCollapseKey() {
        return this.bI.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.bI.getString("google.message_id");
        if (string == null) {
            string = this.bI.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.bI.getString("message_type");
    }

    public long getSentTime() {
        return this.bI.getLong("google.sent_time");
    }

    public int getTtl() {
        Object object = this.bI.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.baR == null && zza.zzac(this.bI)) {
            this.baR = new Notification(this.bI);
        }
        return this.baR;
    }

    public static class Notification {
        private final String DZ;
        private final String baS;
        private final String[] baT;
        private final String zzbfi;
        private final String baU;
        private final String[] baV;
        private final String baW;
        private final String baX;
        private final String mTag;
        private final String JE;
        private final String baY;

        private Notification(Bundle bundle) {
            this.DZ = zza.zzf(bundle, "gcm.n.title");
            this.baS = zza.zzh(bundle, "gcm.n.title");
            this.baT = this.zzj(bundle, "gcm.n.title");
            this.zzbfi = zza.zzf(bundle, "gcm.n.body");
            this.baU = zza.zzh(bundle, "gcm.n.body");
            this.baV = this.zzj(bundle, "gcm.n.body");
            this.baW = zza.zzf(bundle, "gcm.n.icon");
            this.baX = zza.zzat(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.JE = zza.zzf(bundle, "gcm.n.color");
            this.baY = zza.zzf(bundle, "gcm.n.click_action");
        }

        private String[] zzj(Bundle bundle, String string) {
            Object[] objectArray = zza.zzi(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        public String getTitle() {
            return this.DZ;
        }

        public String getTitleLocalizationKey() {
            return this.baS;
        }

        public String[] getTitleLocalizationArgs() {
            return this.baT;
        }

        public String getBody() {
            return this.zzbfi;
        }

        public String getBodyLocalizationKey() {
            return this.baU;
        }

        public String[] getBodyLocalizationArgs() {
            return this.baV;
        }

        public String getIcon() {
            return this.baW;
        }

        public String getSound() {
            return this.baX;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getColor() {
            return this.JE;
        }

        public String getClickAction() {
            return this.baY;
        }
    }

    public static class Builder {
        private final Bundle bI = new Bundle();
        private final Map<String, String> zzctd = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.bI.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzctd.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.bI);
            String string = FirebaseInstanceId.getInstance().getToken();
            if (string != null) {
                this.bI.putString("from", string);
            } else {
                this.bI.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzctd.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzctd.clear();
            this.zzctd.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzctd.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.bI.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.bI.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.bI.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.bI.putString("collapse_key", string);
            return this;
        }
    }
}

