/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzb;
import java.util.Iterator;

public class FirebaseMessagingService
extends com.google.firebase.iid.zzb {
    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string) {
    }

    @WorkerThread
    public void onSendError(String string, Exception exception) {
    }

    protected Intent zzz(Intent intent) {
        return FirebaseInstanceIdInternalReceiver.zzcwz();
    }

    protected int zzaa(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.zzad(intent);
            this.zzbmb();
            FirebaseInstanceIdReceiver.completeWakefulIntent((Intent)intent);
            return 3;
        }
        return super.zzaa(intent);
    }

    private void zzad(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
            }
        }
        if (FirebaseMessagingService.zzav(intent.getExtras())) {
            zzb.zzm((Context)this, intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzm(Intent intent) {
        try {
            switch (intent.getAction()) {
                case "com.google.android.c2dm.intent.RECEIVE": {
                    this.zzn(intent);
                    break;
                }
                case "com.google.firebase.messaging.NOTIFICATION_DISMISS": {
                    if (!FirebaseMessagingService.zzav(intent.getExtras())) break;
                    zzb.zzn((Context)this, intent);
                    break;
                }
                default: {
                    String string = String.valueOf(intent.getAction());
                    Log.d((String)"FirebaseMessaging", (String)(string.length() != 0 ? "Unknown intent action: ".concat(string) : new String("Unknown intent action: ")));
                }
            }
            this.zzbmb();
        }
        finally {
            FirebaseInstanceIdReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void zzn(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                if (FirebaseMessagingService.zzav(intent.getExtras())) {
                    zzb.zzl((Context)this, intent);
                }
                this.zzo(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(this.zzae(intent), new SendException(intent.getStringExtra("error")));
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Received message with unknown type: ".concat(string2) : new String("Received message with unknown type: ")));
            }
        }
    }

    private void zzo(Intent intent) {
        Bundle bundle = intent.getExtras();
        bundle.remove("android.support.content.wakelockid");
        if (zza.zzac(bundle)) {
            if (!zza.zzdc((Context)this)) {
                zza.zzeo((Context)this).zzas(bundle);
                return;
            }
            if (FirebaseMessagingService.zzav(intent.getExtras())) {
                zzb.zzo((Context)this, intent);
            }
        }
        this.onMessageReceived(new RemoteMessage(bundle));
    }

    private String zzae(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            string = intent.getStringExtra("message_id");
        }
        return string;
    }

    static void zzab(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || !string.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    static boolean zzav(Bundle bundle) {
        return "1".equals(bundle.getString("google.c.a.e"));
    }
}

