/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.FirebaseApp;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

class Metadata {
    private static final String GMSCORE_SEND_PERMISSION = "com.google.android.c2dm.permission.SEND";
    static final String GMS_PACKAGE = "com.google.android.gms";
    private static final String ACTION_IID_TOKEN_REQUEST = "com.google.iid.TOKEN_REQUEST";
    private static final String ACTION_C2DM_REGISTER = "com.google.android.c2dm.intent.REGISTER";
    static final int GMSCORE_NOT_FOUND = 0;
    static final int IID_VIA_SERVICE = 1;
    static final int IID_VIA_RECEIVER = 2;
    private final Context context;
    @GuardedBy(value="this")
    private String appVersionCode;
    @GuardedBy(value="this")
    private String appVersionName;
    @GuardedBy(value="this")
    private int gmsVersionCode;
    @GuardedBy(value="this")
    private int iidImplementation = 0;

    Metadata(Context context) {
        this.context = context;
    }

    boolean isGmscorePresent() {
        return this.getIidImplementation() != 0;
    }

    synchronized int getIidImplementation() {
        List infos;
        Intent intent;
        if (this.iidImplementation != 0) {
            return this.iidImplementation;
        }
        PackageManager pm = this.context.getPackageManager();
        int permissionState = pm.checkPermission(GMSCORE_SEND_PERMISSION, GMS_PACKAGE);
        if (permissionState == -1) {
            Log.e((String)"FirebaseMessaging", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!PlatformVersion.isAtLeastO()) {
            intent = new Intent(ACTION_C2DM_REGISTER);
            intent.setPackage(GMS_PACKAGE);
            infos = pm.queryIntentServices(intent, 0);
            if (infos != null && infos.size() > 0) {
                this.iidImplementation = 1;
                return this.iidImplementation;
            }
        }
        intent = new Intent(ACTION_IID_TOKEN_REQUEST);
        intent.setPackage(GMS_PACKAGE);
        infos = pm.queryBroadcastReceivers(intent, 0);
        if (infos != null && infos.size() > 0) {
            this.iidImplementation = 2;
            return this.iidImplementation;
        }
        Log.w((String)"FirebaseMessaging", (String)"Failed to resolve IID implementation package, falling back");
        this.iidImplementation = PlatformVersion.isAtLeastO() ? 2 : 1;
        return this.iidImplementation;
    }

    static String getDefaultSenderId(FirebaseApp app) {
        String senderId = app.getOptions().getGcmSenderId();
        if (senderId != null) {
            return senderId;
        }
        String appId = app.getOptions().getApplicationId();
        if (!appId.startsWith("1:")) {
            return appId;
        }
        String[] parts = appId.split(":");
        if (parts.length < 2) {
            return null;
        }
        String projectId = parts[1];
        if (projectId.isEmpty()) {
            return null;
        }
        return projectId;
    }

    synchronized String getAppVersionCode() {
        if (this.appVersionCode == null) {
            this.populateAppVersionInfo();
        }
        return this.appVersionCode;
    }

    synchronized String getAppVersionName() {
        if (this.appVersionName == null) {
            this.populateAppVersionInfo();
        }
        return this.appVersionName;
    }

    synchronized int getGmsVersionCode() {
        PackageInfo info;
        if (this.gmsVersionCode == 0 && (info = this.getPackageInfo(GMS_PACKAGE)) != null) {
            this.gmsVersionCode = info.versionCode;
        }
        return this.gmsVersionCode;
    }

    private synchronized void populateAppVersionInfo() {
        PackageInfo info = this.getPackageInfo(this.context.getPackageName());
        if (info != null) {
            this.appVersionCode = Integer.toString(info.versionCode);
            this.appVersionName = info.versionName;
        }
    }

    private PackageInfo getPackageInfo(String packageName) {
        try {
            return this.context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)"FirebaseMessaging", (String)("Failed to find package " + (Object)((Object)e)));
            return null;
        }
    }
}

