/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class Store {
    final SharedPreferences store;

    public synchronized Token getToken(String string, String string2) {
        return Token.parse(this.store.getString(this.createTokenKey(string, string2), null));
    }

    private String createTokenKey(String string, String string2) {
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 5 + n2);
        stringBuilder.append(string);
        stringBuilder.append("|T|");
        stringBuilder.append(string2);
        stringBuilder.append("|*");
        return stringBuilder.toString();
    }

    public Store(Context context) {
        this.store = context.getSharedPreferences("com.google.android.gms.appid", 0);
        this.checkForRestore(context, "com.google.android.gms.appid-no-backup");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForRestore(Context object, String object2) {
        File file = ContextCompat.getNoBackupFilesDir((Context)object);
        File file2 = new File(file, "com.google.android.gms.appid-no-backup");
        if (file2.exists()) {
            return;
        }
        try {
            boolean bl;
            boolean bl2 = file2.createNewFile();
            if (!bl2 || (bl = this.isEmpty())) return;
            Log.i((String)"FirebaseMessaging", (String)"App restored, clearing state");
            this.deleteAll();
            return;
        }
        catch (IOException iOException) {
            if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                return;
            }
            String string = String.valueOf(iOException.getMessage());
            String string2 = "Error creating file in no backup dir: ";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            Log.d((String)"FirebaseMessaging", (String)string);
            return;
        }
    }

    public synchronized void deleteAll() {
        this.store.edit().clear().commit();
    }

    public synchronized void deleteToken(String string, String string2) {
        string = store.createTokenKey(string, string2);
        Store store = store.store.edit();
        store.remove(string);
        store.commit();
    }

    public synchronized void saveToken(String string, String string2, String string3, String string4) {
        if ((string3 = Token.encode(string3, string4, System.currentTimeMillis())) == null) {
            return;
        }
        string4 = this.store.edit();
        string4.putString(this.createTokenKey(string, string2), string3);
        string4.commit();
    }

    public synchronized boolean isEmpty() {
        return this.store.getAll().isEmpty();
    }

    static class Token {
        private static final long REFRESH_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(7L);
        final String token;
        final String appVersion;
        final long timestamp;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Token parse(String object) {
            if (TextUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            if (!((String)object).startsWith("{")) return new Token((String)object, null, 0L);
            try {
                JSONObject jSONObject = new JSONObject((String)object);
                return new Token(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
            }
            catch (JSONException jSONException) {
                Log.w((String)"FirebaseMessaging", (String)"Failed to parse token: ".concat(((Object)((Object)jSONException)).toString()));
                return null;
            }
        }

        static String encode(String string, String string2, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", (Object)string);
                jSONObject.put("appVersion", (Object)string2);
                jSONObject.put("timestamp", l);
                string = jSONObject.toString();
                return string;
            }
            catch (JSONException jSONException) {
                Log.w((String)"FirebaseMessaging", (String)"Failed to encode token: ".concat(((Object)((Object)jSONException)).toString()));
                return null;
            }
        }

        private Token(String string, String string2, long l) {
            this.token = string;
            this.appVersion = string2;
            this.timestamp = l;
        }

        boolean needsRefresh(String string) {
            return System.currentTimeMillis() > this.timestamp + REFRESH_PERIOD_MILLIS || !string.equals(this.appVersion);
        }
    }
}

