/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.CommonNotificationBuilder;
import com.google.firebase.messaging.ImageDownload;
import com.google.firebase.messaging.NotificationParams;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DisplayNotification {
    private final Executor networkIoExecutor;
    private final Context context;
    private final NotificationParams params;

    @Nullable
    private ImageDownload startImageDownloadInBackground() {
        ImageDownload imageDownload = ImageDownload.create(this.params.getString("gcm.n.image"));
        if (imageDownload != null) {
            imageDownload.start(this.networkIoExecutor);
        }
        return imageDownload;
    }

    public DisplayNotification(Context context, NotificationParams notificationParams, Executor executor) {
        this.networkIoExecutor = executor;
        this.context = context;
        this.params = notificationParams;
    }

    private void showNotification(CommonNotificationBuilder.DisplayNotificationInfo displayNotificationInfo) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        ((NotificationManager)this.context.getSystemService("notification")).notify(displayNotificationInfo.tag, displayNotificationInfo.id, displayNotificationInfo.notificationBuilder.build());
    }

    private void waitForAndApplyImageDownload(NotificationCompat.Builder builder, @Nullable ImageDownload imageDownload) {
        if (imageDownload == null) {
            return;
        }
        try {
            DisplayNotification displayNotification = (Bitmap)Tasks.await(imageDownload.getTask(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
            builder.setLargeIcon((Bitmap)displayNotification);
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            builder.setStyle((NotificationCompat.Style)bigPictureStyle.bigPicture((Bitmap)displayNotification).bigLargeIcon(null));
            return;
        }
        catch (ExecutionException executionException) {
            String string = String.valueOf(executionException.getCause());
            String.valueOf(string).length();
            Log.w((String)"FirebaseMessaging", (String)"Failed to download image: ".concat(String.valueOf(string)));
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)"FirebaseMessaging", (String)"Interrupted while downloading image, showing notification without it");
            imageDownload.close();
            Thread.currentThread().interrupt();
            return;
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)"FirebaseMessaging", (String)"Failed to download image in time, showing notification without it");
            imageDownload.close();
            return;
        }
    }

    boolean handleNotification() {
        if (this.params.getBoolean("gcm.n.noui")) {
            return true;
        }
        if (this.isAppForeground()) {
            return false;
        }
        ImageDownload imageDownload = this.startImageDownloadInBackground();
        CommonNotificationBuilder.DisplayNotificationInfo displayNotificationInfo = CommonNotificationBuilder.createNotificationInfo(this.context, this.params);
        this.waitForAndApplyImageDownload(displayNotificationInfo.notificationBuilder, imageDownload);
        this.showNotification(displayNotificationInfo);
        return true;
    }

    private boolean isAppForeground() {
        if (((KeyguardManager)((DisplayNotification)object).context.getSystemService("keyguard")).inKeyguardRestrictedInputMode()) {
            return false;
        }
        if (!PlatformVersion.isAtLeastLollipop()) {
            SystemClock.sleep((long)10L);
        }
        int n = Process.myPid();
        Object object = ((ActivityManager)((DisplayNotification)object).context.getSystemService("activity")).getRunningAppProcesses();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }
}

