/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.FirebaseApp;
import javax.annotation.concurrent.GuardedBy;

class Metadata {
    private final Context context;
    @GuardedBy(value="this")
    private String appVersionCode;
    @GuardedBy(value="this")
    private String appVersionName;
    @GuardedBy(value="this")
    private int gmsVersionCode;
    @GuardedBy(value="this")
    private int iidImplementation = 0;

    Metadata(Context context) {
        this.context = context;
    }

    boolean isGmscorePresent() {
        return this.getIidImplementation() != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized int getIidImplementation() {
        block8: {
            Object object;
            Object object2;
            block7: {
                int n = this.iidImplementation;
                if (n != 0) {
                    return n;
                }
                object2 = this.context.getPackageManager();
                if (object2.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
                    Log.e((String)"FirebaseMessaging", (String)"Google Play services missing or without correct permission.");
                    return 0;
                }
                if (PlatformVersion.isAtLeastO()) break block7;
                object = new Intent("com.google.android.c2dm.intent.REGISTER");
                object.setPackage("com.google.android.gms");
                object = object2.queryIntentServices((Intent)object, 0);
                if (object != null && object.size() > 0) break block8;
            }
            object = new Intent("com.google.iid.TOKEN_REQUEST");
            object.setPackage("com.google.android.gms");
            object2 = object2.queryBroadcastReceivers((Intent)object, 0);
            if (object2 == null || object2.size() <= 0) {
                Log.w((String)"FirebaseMessaging", (String)"Failed to resolve IID implementation package, falling back");
                if (PlatformVersion.isAtLeastO()) {
                    this.iidImplementation = 2;
                    return 2;
                }
                this.iidImplementation = 1;
                return 1;
            }
            this.iidImplementation = 2;
            return 2;
        }
        this.iidImplementation = 1;
        return 1;
    }

    static String getDefaultSenderId(FirebaseApp object) {
        String string = object.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        if (!((String)(object = object.getOptions().getApplicationId())).startsWith("1:")) {
            return object;
        }
        if (((Object)(object = ((String)object).split(":"))).length < 2) {
            return null;
        }
        if (((String)(object = object[1])).isEmpty()) {
            return null;
        }
        return object;
    }

    synchronized String getAppVersionCode() {
        if (this.appVersionCode == null) {
            this.populateAppVersionInfo();
        }
        return this.appVersionCode;
    }

    synchronized String getAppVersionName() {
        if (this.appVersionName == null) {
            this.populateAppVersionInfo();
        }
        return this.appVersionName;
    }

    synchronized int getGmsVersionCode() {
        PackageInfo packageInfo;
        if (this.gmsVersionCode == 0 && (packageInfo = this.getPackageInfo("com.google.android.gms")) != null) {
            this.gmsVersionCode = packageInfo.versionCode;
        }
        return this.gmsVersionCode;
    }

    private synchronized void populateAppVersionInfo() {
        PackageInfo packageInfo = this.getPackageInfo(this.context.getPackageName());
        if (packageInfo != null) {
            this.appVersionCode = Integer.toString(packageInfo.versionCode);
            this.appVersionName = packageInfo.versionName;
            return;
        }
    }

    private PackageInfo getPackageInfo(String string) {
        try {
            Metadata metadata = metadata.context.getPackageManager().getPackageInfo(string, 0);
            return metadata;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            string = String.valueOf(string2);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 23);
            stringBuilder.append("Failed to find package ");
            stringBuilder.append(string2);
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return null;
        }
    }
}

