/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.firebase.messaging.DisplayNotification;
import com.google.firebase.messaging.EnhancedIntentService;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.ServiceStarter;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;

public class FirebaseMessagingService
extends EnhancedIntentService {
    public static final String ACTION_DIRECT_BOOT_REMOTE_INTENT = "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT";
    private static final Queue<String> recentlyReceivedMessageIds;

    @WorkerThread
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(@NonNull String string) {
    }

    @WorkerThread
    public void onSendError(@NonNull String string, @NonNull Exception exception) {
    }

    @WorkerThread
    public void onNewToken(@NonNull String string) {
    }

    @Override
    protected Intent getStartCommandIntent(Intent intent) {
        return ServiceStarter.getInstance().getMessagingEvent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleIntent(Intent intent) {
        String string;
        String string2 = intent.getAction();
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string2) || ACTION_DIRECT_BOOT_REMOTE_INTENT.equals(string2)) {
            ((FirebaseMessagingService)((Object)object)).handleMessageIntent((Intent)string);
            return;
        }
        if ("com.google.firebase.messaging.NEW_TOKEN".equals(string2)) {
            ((FirebaseMessagingService)((Object)object)).onNewToken(string.getStringExtra("token"));
            return;
        }
        Object object = String.valueOf(string.getAction());
        string = "Unknown intent action: ";
        object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
        Log.d((String)"FirebaseMessaging", (String)object);
    }

    private void handleMessageIntent(Intent intent) {
        if (!this.alreadyReceivedMessage(intent.getStringExtra("google.message_id"))) {
            this.passMessageIntentToSdk(intent);
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void passMessageIntentToSdk(Intent var1_1) {
        var2_2 = var1_1 /* !! */ .getStringExtra("message_type");
        if (var2_2 == null) {
            var2_2 = "gcm";
        }
        switch (var2_2.hashCode()) lbl-1000:
        // 4 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var3_3 = -1;
lbl8:
                    // 5 sources

                    while (true) {
                        switch (var3_3) {
                            default: {
                                this = "Received message with unknown type: ";
                                if (var2_2.length() != 0) {
                                    this = this.concat(var2_2);
lbl14:
                                    // 2 sources

                                    while (true) {
                                        Log.w((String)"FirebaseMessaging", (String)this);
                                        return;
                                    }
                                }
                                var1_1 /* !! */  = new String((String)this);
                                this = var1_1 /* !! */ ;
                                ** continue;
                            }
                            case 3: {
                                var2_2 = this.getMessageId(var1_1 /* !! */ );
                                var3_4 = new SendException(var1_1 /* !! */ .getStringExtra("error"));
                                this.onSendError(var2_2, var3_4);
                                return;
                            }
                            case 2: {
                                this.onMessageSent(var1_1 /* !! */ .getStringExtra("google.message_id"));
                                return;
                            }
                            case 1: {
                                this.onDeletedMessages();
                                return;
                            }
                            case 0: 
                        }
                        MessagingAnalytics.logNotificationReceived(var1_1 /* !! */ );
                        this.dispatchMessage(var1_1 /* !! */ );
                        return;
                    }
                    break;
                }
            }
            case 814800675: {
                if (!var2_2.equals("send_event")) ** GOTO lbl-1000
                var3_3 = 2;
                ** GOTO lbl8
            }
            case 814694033: {
                if (!var2_2.equals("send_error")) ** GOTO lbl-1000
                var3_3 = 3;
                ** GOTO lbl8
            }
            case 102161: {
                if (!var2_2.equals("gcm")) ** GOTO lbl-1000
                var3_3 = 0;
                ** GOTO lbl8
            }
            case -2062414158: 
        }
        ** while (!var2_2.equals((Object)"deleted_messages"))
lbl50:
        // 1 sources

        var3_3 = 1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchMessage(Intent object) {
        Bundle bundle = object.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.remove("androidx.content.wakelockid");
        if (NotificationParams.isNotification(bundle)) {
            NotificationParams notificationParams = new NotificationParams(bundle);
            ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
            DisplayNotification displayNotification = new DisplayNotification((Context)this, notificationParams, executorService);
            try {
                boolean bl = displayNotification.handleNotification();
                if (bl) {
                    executorService.shutdown();
                    return;
                }
                executorService.shutdown();
            }
            catch (Throwable throwable) {
                executorService.shutdown();
                throw throwable;
            }
            if (MessagingAnalytics.shouldUploadScionMetrics(object)) {
                MessagingAnalytics.logNotificationForeground(object);
            }
        }
        object = new RemoteMessage(bundle);
        this.onMessageReceived((RemoteMessage)((Object)object));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean alreadyReceivedMessage(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (recentlyReceivedMessageIds.contains(string)) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Object object = String.valueOf(string);
                string = "Received duplicate message: ";
                object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
                Log.d((String)"FirebaseMessaging", (String)object);
            }
            return true;
        }
        if (recentlyReceivedMessageIds.size() >= 10) {
            recentlyReceivedMessageIds.remove();
        }
        recentlyReceivedMessageIds.add(string);
        return false;
    }

    private String getMessageId(Intent intent) {
        Object object = intent.getStringExtra("google.message_id");
        if (object == null) {
            return intent.getStringExtra("message_id");
        }
        return object;
    }

    static {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(10);
        recentlyReceivedMessageIds = arrayDeque;
    }
}

