/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.Metadata;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.zzj;
import com.google.firebase.messaging.zzk;
import com.google.firebase.messaging.zzl;
import com.google.firebase.messaging.zzs;
import com.google.firebase.messaging.zzy;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private final Context zzb;
    private final FirebaseInstanceId zzc;
    private final Task<zzy> zzd;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory zza;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
    }

    FirebaseMessaging(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory) {
        zza = transportFactory;
        this.zzc = firebaseInstanceId;
        this.zzb = firebaseApp.getApplicationContext();
        this.zzd = zzy.zza(firebaseApp, firebaseInstanceId, new Metadata(this.zzb), userAgentPublisher, heartBeatInfo, firebaseInstallationsApi, this.zzb, new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Firebase-Messaging-Topics-Io")));
        String string = "Firebase-Messaging-Trigger-Topics-Io";
        this.zzd.addOnSuccessListener((Executor)new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(string)), (OnSuccessListener)new zzk(this));
    }

    public boolean isAutoInitEnabled() {
        return this.zzc.isFcmAutoInitEnabled();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.zzc.setFcmAutoInitEnabled(bl);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return zzs.zza();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean bl) {
        zzs.zza(bl);
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String string) {
        return this.zzd.onSuccessTask((SuccessContinuation)new zzj(string));
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String string) {
        return this.zzd.onSuccessTask((SuccessContinuation)new zzl(string));
    }

    public void send(@NonNull RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.zzb, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        Intent intent3 = intent;
        RemoteMessage remoteMessage2 = remoteMessage;
        intent3.putExtras(remoteMessage2.zza);
        this.zzb.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }
}

