/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzt;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzb {
    private static final AtomicInteger zza = new AtomicInteger((int)SystemClock.elapsedRealtime());

    static zza zza(Context context, zzt zzt2) {
        String string;
        int[] nArray;
        long[] lArray;
        Long l;
        Object object;
        Object object2;
        Integer n;
        Object object3;
        Integer n2;
        Object object4;
        boolean bl;
        Integer n3;
        PendingIntent pendingIntent;
        PendingIntent pendingIntent2;
        PendingIntent pendingIntent3;
        Intent intent;
        Intent intent2;
        Uri uri;
        String string2;
        Bundle bundle;
        Bundle bundle2 = bundle = zzb.zza(context.getPackageManager(), context.getPackageName());
        PackageManager packageManager = context.getPackageManager();
        Resources resources = context.getResources();
        String string3 = zzb.zzb(context, zzt2.zza("gcm.n.android_channel_id"), bundle);
        zzt zzt3 = zzt2;
        String string4 = context.getPackageName();
        Context context2 = context;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context2, string3);
        String string5 = zzt3.zza(resources, string4, "gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            builder.setContentTitle((CharSequence)string5);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = zzt3.zza(resources, string4, "gcm.n.body")))) {
            builder.setContentText((CharSequence)string2);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string2));
        }
        int n4 = zzb.zza(packageManager, resources, string4, zzt3.zza("gcm.n.icon"), bundle2);
        builder.setSmallIcon(n4);
        Object object5 = resources;
        Object object6 = zzt3;
        Object object7 = string4;
        String string6 = ((zzt)object6).zzb();
        if ((TextUtils.isEmpty((CharSequence)string6) ? null : (uri = !"default".equals(string6) && object5.getIdentifier(string6, "raw", (String)object7) != 0 ? Uri.parse((String)new StringBuilder(24 + String.valueOf(object7).length() + String.valueOf(string6).length()).append("android.resource://").append((String)object7).append("/raw/").append(string6).toString()) : RingtoneManager.getDefaultUri((int)2))) != null) {
            builder.setSound(uri);
        }
        string6 = packageManager;
        object5 = string4;
        object6 = zzt3;
        object7 = context2;
        String string7 = string6;
        zzt zzt4 = object6;
        Object object8 = object5;
        String string8 = zzt4.zza("gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string8)) {
            Intent intent3 = new Intent(string8);
            intent3.setPackage((String)object8);
            intent3.setFlags(0x10000000);
            intent2 = intent3;
        } else {
            Intent intent4;
            Uri uri2 = zzt4.zza();
            if (uri2 != null) {
                intent4 = new Intent("android.intent.action.VIEW");
                intent4.setPackage((String)object8);
                intent4.setData(uri2);
            } else {
                intent4 = string7.getLaunchIntentForPackage((String)object8);
                if (intent4 == null) {
                    Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
                }
            }
            intent2 = intent = intent4;
        }
        if (intent2 == null) {
            pendingIntent3 = null;
        } else {
            intent.addFlags(0x4000000);
            intent.putExtras(((zzt)object6).zze());
            PendingIntent pendingIntent4 = PendingIntent.getActivity((Context)object7, (int)zza.incrementAndGet(), (Intent)intent, (int)0x40000000);
            if (((zzt)object6).zzb("google.c.a.e")) {
                string7 = pendingIntent4;
                zzt4 = object6;
                object8 = object7;
                string8 = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN").putExtras(zzt4.zzf()).putExtra("pending_intent", (Parcelable)string7);
                pendingIntent4 = zzb.zza((Context)object8, (Intent)string8);
            }
            pendingIntent3 = pendingIntent4;
        }
        builder.setContentIntent(pendingIntent3);
        object6 = zzt3;
        object7 = context2;
        if (!((zzt)object6).zzb("google.c.a.e")) {
            pendingIntent2 = null;
        } else {
            object5 = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS").putExtras(((zzt)object6).zzf());
            pendingIntent2 = pendingIntent = zzb.zza((Context)object7, (Intent)object5);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent);
        }
        if ((n3 = zzb.zza(context2, zzt3.zza("gcm.n.color"), bundle2)) != null) {
            builder.setColor(n3.intValue());
        }
        builder.setAutoCancel(!(bl = zzt3.zzb("gcm.n.sticky")));
        boolean bl2 = zzt3.zzb("gcm.n.local_only");
        builder.setLocalOnly(bl2);
        String string9 = zzt3.zza("gcm.n.ticker");
        if (string9 != null) {
            builder.setTicker((CharSequence)string9);
        }
        if ((object6 = zzt3.zzc("gcm.n.notification_priority")) == null) {
            object4 = null;
        } else if ((Integer)object6 < -2 || (Integer)object6 > 2) {
            object5 = String.valueOf(object6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(72 + String.valueOf(object5).length()).append("notificationPriority is invalid ").append((String)object5).append(". Skipping setting notificationPriority.").toString());
            object4 = null;
        } else {
            object4 = n2 = object6;
        }
        if (object4 != null) {
            builder.setPriority(n2.intValue());
        }
        if ((object6 = zzt3.zzc("gcm.n.visibility")) == null) {
            object3 = null;
        } else if ((Integer)object6 < -1 || (Integer)object6 > 1) {
            object5 = String.valueOf(object6);
            Log.w((String)"NotificationParams", (String)new StringBuilder(53 + String.valueOf(object5).length()).append("visibility is invalid: ").append((String)object5).append(". Skipping setting visibility.").toString());
            object3 = null;
        } else {
            object3 = n = object6;
        }
        if (object3 != null) {
            builder.setVisibility(n.intValue());
        }
        if ((object6 = zzt3.zzc("gcm.n.notification_count")) == null) {
            object2 = null;
        } else if ((Integer)object6 < 0) {
            object5 = String.valueOf(object6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(67 + String.valueOf(object5).length()).append("notificationCount is invalid: ").append((String)object5).append(". Skipping setting notificationCount.").toString());
            object2 = null;
        } else {
            object2 = object = object6;
        }
        if (object2 != null) {
            builder.setNumber(((Integer)object).intValue());
        }
        if ((l = zzt3.zzd("gcm.n.event_time")) != null) {
            builder.setShowWhen(true);
            builder.setWhen(l.longValue());
        }
        if ((lArray = zzt3.zzc()) != null) {
            builder.setVibrate(lArray);
        }
        if ((nArray = zzt3.zzd()) != null) {
            builder.setLights(nArray[0], nArray[1], nArray[2]);
        }
        object7 = zzt3;
        int n5 = 0;
        if (((zzt)object7).zzb("gcm.n.default_sound")) {
            n5 = 1;
        }
        if (((zzt)object7).zzb("gcm.n.default_vibrate_timings")) {
            n5 |= 2;
        }
        if (((zzt)object7).zzb("gcm.n.default_light_settings")) {
            n5 |= 4;
        }
        builder.setDefaults(n5);
        String string10 = zzt3.zza("gcm.n.tag");
        if (!TextUtils.isEmpty((CharSequence)string10)) {
            string = string10;
        } else {
            long l2 = SystemClock.uptimeMillis();
            string = new StringBuilder(37).append("FCM-Notification:").append(l2).toString();
        }
        return new zza(builder, string, 0);
    }

    @TargetApi(value=26)
    private static boolean zza(Resources resources, int n) {
        if (Build.VERSION.SDK_INT != 26) {
            return true;
        }
        try {
            if (resources.getDrawable(n, null) instanceof AdaptiveIconDrawable) {
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(77).append("Adaptive icons cannot be used in notifications. Ignoring icon id: ").append(n).toString());
                return false;
            }
            return true;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e((String)"FirebaseMessaging", (String)new StringBuilder(66).append("Couldn't find resource ").append(n).append(", treating it as an invalid icon").toString());
            return false;
        }
    }

    private static int zza(PackageManager packageManager, Resources resources, String string, String string2, Bundle bundle) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            n = resources.getIdentifier(string2, "drawable", string);
            if (n != 0 && zzb.zza(resources, n)) {
                return n;
            }
            n = resources.getIdentifier(string2, "mipmap", string);
            if (n != 0 && zzb.zza(resources, n)) {
                return n;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(string2).length()).append("Icon resource ").append(string2).append(" not found. Notification will use default icon.").toString());
        }
        if ((n = bundle.getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0 || !zzb.zza(resources, n)) {
            try {
                n = packageManager.getApplicationInfo((String)string, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string3 = String.valueOf((Object)nameNotFoundException);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string3).length()).append("Couldn't get own application info: ").append(string3).toString());
            }
        }
        if (n == 0 || !zzb.zza(resources, n)) {
            n = 17301651;
        }
        return n;
    }

    private static Integer zza(Context context, String string, Bundle bundle) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                return Color.parseColor((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(56 + String.valueOf(string).length()).append("Color is invalid: ").append(string).append(". Notification will use default color.").toString());
            }
        }
        if ((n = bundle.getInt("com.google.firebase.messaging.default_notification_color", 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)context, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    private static Bundle zza(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                return applicationInfo.metaData;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string2).length()).append("Couldn't get own application info: ").append(string2).toString());
        }
        return Bundle.EMPTY;
    }

    @TargetApi(value=26)
    private static String zzb(Context context, String string, Bundle bundle) {
        String string2;
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        try {
            if (context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).targetSdkVersion < 26) {
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (notificationManager.getNotificationChannel(string) != null) {
                return string;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(122 + String.valueOf(string).length()).append("Notification Channel requested (").append(string).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = bundle.getString("com.google.firebase.messaging.default_notification_channel_id")))) {
            if (notificationManager.getNotificationChannel(string2) != null) {
                return string2;
            }
            Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
        } else {
            Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
        }
        if (notificationManager.getNotificationChannel("fcm_fallback_notification_channel") == null) {
            int n = context.getResources().getIdentifier("fcm_fallback_notification_channel_label", "string", context.getPackageName());
            notificationManager.createNotificationChannel(new NotificationChannel("fcm_fallback_notification_channel", (CharSequence)context.getString(n), 3));
        }
        return "fcm_fallback_notification_channel";
    }

    private static PendingIntent zza(Context context, Intent intent) {
        return PendingIntent.getBroadcast((Context)context, (int)zza.incrementAndGet(), (Intent)new Intent("com.google.firebase.MESSAGING_EVENT").setComponent(new ComponentName(context, "com.google.firebase.iid.FirebaseInstanceIdReceiver")).putExtra("wrapped_intent", (Parcelable)intent), (int)0x40000000);
    }
}

