/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzv;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zzc;
import com.google.firebase.messaging.zzd;
import com.google.firebase.messaging.zzk;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FirebaseMessagingService
extends zzc {
    private static final Queue<String> zza = new ArrayDeque<String>(10);

    @WorkerThread
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(@NonNull String string) {
    }

    @WorkerThread
    public void onSendError(@NonNull String string, @NonNull Exception exception) {
    }

    @WorkerThread
    public void onNewToken(@NonNull String string) {
    }

    @Override
    protected final Intent zza(Intent intent) {
        return zzaq.zza().zzb();
    }

    @Override
    public final boolean zzb(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            Intent intent2 = intent;
            PendingIntent pendingIntent = (PendingIntent)intent2.getParcelableExtra("pending_intent");
            if (pendingIntent != null) {
                try {
                    pendingIntent.send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
                }
            }
            if (MessagingAnalytics.shouldUploadMetrics(intent2)) {
                MessagingAnalytics.logNotificationOpen(intent2);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final void zzc(Intent var1_1) {
        block35: {
            block36: {
                var2_2 = var1_1.getAction();
                if (!"com.google.android.c2dm.intent.RECEIVE".equals(var2_2) && !"com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(var2_2)) break block35;
                var4_3 = var1_1;
                var3_4 = this;
                var10_6 = var5_5 = var4_3.getStringExtra("google.message_id");
                var9_7 = var3_4;
                if (TextUtils.isEmpty((CharSequence)var10_6)) {
                    v0 = Tasks.forResult(null);
                } else {
                    var11_8 /* !! */  = new Bundle();
                    var11_8 /* !! */ .putString("google.message_id", var10_6);
                    v0 = zzv.zza((Context)var9_7).zza(2, var11_8 /* !! */ );
                }
                var6_9 = v0;
                var9_7 = var5_5;
                if (TextUtils.isEmpty((CharSequence)var9_7)) {
                    v1 = false;
                } else if (FirebaseMessagingService.zza.contains(var9_7)) {
                    if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                        v2 = String.valueOf(var9_7);
                        Log.d((String)"FirebaseMessaging", (String)(v2.length() != 0 ? "Received duplicate message: ".concat(v2) : new String("Received duplicate message: ")));
                    }
                    v1 = true;
                } else {
                    if (FirebaseMessagingService.zza.size() >= 10) {
                        FirebaseMessagingService.zza.remove();
                    }
                    FirebaseMessagingService.zza.add((String)var9_7);
                    v1 = false;
                }
                if (v1) break block36;
                var10_6 = var4_3;
                var9_7 = var3_4;
                var11_8 /* !! */  = var10_6.getStringExtra("message_type");
                if (var11_8 /* !! */  == null) {
                    var11_8 /* !! */  = "gcm";
                }
                var12_10 = var11_8 /* !! */ ;
                var13_11 = -1;
                switch (var12_10.hashCode()) {
                    case 102161: {
                        if (!var12_10.equals("gcm")) break;
                        var13_11 = 0;
                        break;
                    }
                    case -2062414158: {
                        if (!var12_10.equals("deleted_messages")) break;
                        var13_11 = 1;
                        break;
                    }
                    case 814800675: {
                        if (!var12_10.equals("send_event")) break;
                        var13_11 = 2;
                        break;
                    }
                    case 814694033: {
                        if (!var12_10.equals("send_error")) break;
                        var13_11 = 3;
                    }
                }
                switch (var13_11) {
                    case 0: {
                        if (MessagingAnalytics.shouldUploadMetrics((Intent)var10_6)) {
                            MessagingAnalytics.logNotificationReceived((Intent)var10_6);
                        }
                        var17_12 = var10_6;
                        var16_13 = var9_7;
                        var18_14 = var17_12.getExtras();
                        if (var18_14 == null) {
                            var18_14 = new Bundle();
                        }
                        var18_14.remove("androidx.contentpager.content.wakelockid");
                        if (!zzk.zza(var18_14)) ** GOTO lbl78
                        var19_15 = new zzk(var18_14);
                        var20_16 = Executors.newSingleThreadExecutor();
                        var21_17 = new zzd((Context)var16_13, var19_15, var20_16);
                        try {
                            if (var21_17.zza()) {
                                break;
                            }
                        }
                        finally {
                            var20_16.shutdown();
                        }
                        if (MessagingAnalytics.shouldUploadMetrics((Intent)var17_12)) {
                            MessagingAnalytics.logNotificationForeground((Intent)var17_12);
                        }
lbl78:
                        // 4 sources

                        var16_13.onMessageReceived(new RemoteMessage(var18_14));
                        break;
                    }
                    case 1: {
                        var9_7.onDeletedMessages();
                        break;
                    }
                    case 2: {
                        var9_7.onMessageSent(var10_6.getStringExtra("google.message_id"));
                        break;
                    }
                    case 3: {
                        var14_19 = var10_6;
                        var15_20 = var14_19.getStringExtra("google.message_id");
                        if (var15_20 == null) {
                            var15_20 = var14_19.getStringExtra("message_id");
                        }
                        var9_7.onSendError(var15_20, new SendException(var10_6.getStringExtra("error")));
                        break;
                    }
                    default: {
                        v3 = String.valueOf(var11_8 /* !! */ );
                        Log.w((String)"FirebaseMessaging", (String)(v3.length() != 0 ? "Received message with unknown type: ".concat(v3) : new String("Received message with unknown type: ")));
                    }
                }
            }
            try {
                Tasks.await((Task)var6_9, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                return;
            }
            catch (InterruptedException | ExecutionException | TimeoutException var7_21) {
                var8_22 = String.valueOf(var7_21);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(20 + String.valueOf(var8_22).length()).append("Message ack failed: ").append(var8_22).toString());
                return;
            }
        }
        if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(var2_2)) {
            if (MessagingAnalytics.shouldUploadMetrics(var1_1)) {
                MessagingAnalytics.logNotificationDismiss(var1_1);
                return;
            }
        } else {
            if ("com.google.firebase.messaging.NEW_TOKEN".equals(var2_2)) {
                this.onNewToken(var1_1.getStringExtra("token"));
                return;
            }
            v4 = String.valueOf(var1_1.getAction());
            Log.d((String)"FirebaseMessaging", (String)(v4.length() != 0 ? "Unknown intent action: ".concat(v4) : new String("Unknown intent action: ")));
        }
    }
}

