/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_messaging.zzk;
import com.google.android.gms.internal.firebase_messaging.zzm;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.zzi;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

final class zzj
implements Closeable {
    private final URL zza;
    @Nullable
    private Task<Bitmap> zzb;
    @Nullable
    private volatile InputStream zzc;

    @Nullable
    public static zzj zza(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return new zzj(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = String.valueOf(string);
            Log.w((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Not downloading image, bad URL: ".concat(string2) : new String("Not downloading image, bad URL: ")));
            return null;
        }
    }

    private zzj(URL uRL) {
        this.zza = uRL;
    }

    public final void zza(Executor executor) {
        this.zzb = Tasks.call((Executor)executor, (Callable)new zzi(this));
    }

    public final Task<Bitmap> zza() {
        return (Task)Preconditions.checkNotNull(this.zzb);
    }

    public final Bitmap zzb() throws IOException {
        Object object = String.valueOf(this.zza);
        Log.i((String)"FirebaseMessaging", (String)new StringBuilder(22 + String.valueOf(object).length()).append("Starting download of: ").append((String)object).toString());
        byte[] byArray = this.zzc();
        object = byArray;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)((Object)object).length);
        if (bitmap == null) {
            String string = String.valueOf(this.zza);
            throw new IOException(new StringBuilder(24 + String.valueOf(string).length()).append("Failed to decode image: ").append(string).toString());
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            String string = String.valueOf(this.zza);
            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Successfully downloaded image: ").append(string).toString());
        }
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] zzc() throws IOException {
        byte[] byArray;
        Object object;
        block9: {
            URLConnection uRLConnection = this.zza.openConnection();
            if (uRLConnection.getContentLength() > 0x100000) {
                throw new IOException("Content-Length exceeds max size of 1048576");
            }
            InputStream inputStream = uRLConnection.getInputStream();
            object = null;
            try {
                this.zzc = inputStream;
                byArray = com.google.android.gms.internal.firebase_messaging.zzj.zza(com.google.android.gms.internal.firebase_messaging.zzj.zza(inputStream, 0x100001L));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (inputStream == null) throw throwable3;
                    if (object == null) {
                        inputStream.close();
                        throw throwable3;
                    }
                    try {
                        inputStream.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        zzm.zza((Throwable)object, (Throwable)throwable4);
                        throw throwable3;
                    }
                }
            }
            inputStream.close();
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)2)) {
            int n = byArray.length;
            object = String.valueOf(this.zza);
            Log.v((String)"FirebaseMessaging", (String)new StringBuilder(34 + String.valueOf(object).length()).append("Downloaded ").append(n).append(" bytes from ").append((String)object).toString());
        }
        if (byArray.length <= 0x100000) return byArray;
        throw new IOException("Image exceeds max size of 1048576");
    }

    @Override
    public final void close() {
        zzk.zza(this.zzc);
    }
}

