/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase_messaging.zzac;
import com.google.android.gms.internal.firebase_messaging.zzq;
import com.google.firebase.messaging.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    @SafeParcelable.Field(id=2)
    Bundle zzdw;
    private Map<String, String> zzdx;
    private Notification zzdy;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzdw = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzdw, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzdw.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzdw.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdx == null) {
            Bundle bundle = this.zzdw;
            ArrayMap arrayMap = new ArrayMap();
            for (String string : bundle.keySet()) {
                Object object = bundle.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                arrayMap.put((Object)string, (Object)string2);
            }
            this.zzdx = arrayMap;
        }
        return this.zzdx;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzdw.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string = this.zzdw.getString("google.message_id");
        if (string == null) {
            string = this.zzdw.getString("message_id");
        }
        return string;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzdw.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzdw.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzdw.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string = this.zzdw.getString("google.original_priority");
        if (string == null) {
            string = this.zzdw.getString("google.priority");
        }
        return RemoteMessage.zzm(string);
    }

    public final int getPriority() {
        String string = this.zzdw.getString("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.zzdw.getString("google.priority_reduced"))) {
                return 2;
            }
            string = this.zzdw.getString("google.priority");
        }
        return RemoteMessage.zzm(string);
    }

    private static int zzm(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzdy == null) {
            this.zzdy = Notification.zzf(this.zzdw);
        }
        return this.zzdy;
    }

    @KeepForSdk
    public final Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.zzdw);
        return intent;
    }

    public static class Notification {
        private final String zzdz;
        private final String zzea;
        private final String[] zzeb;
        private final String zzec;
        private final String zzed;
        private final String[] zzee;
        private final String zzef;
        private final String zzeg;
        private final String tag;
        private final String zzeh;
        private final String zzei;
        private final String zzej;
        private final Uri zzek;

        @Nullable
        private static Notification zzf(Bundle bundle) {
            if (zzac.zzj(bundle)) {
                return new Notification(new zzq("FirebaseMessaging", bundle));
            }
            return null;
        }

        private Notification(zzq zzq2) {
            this.zzdz = zzq2.getString("gcm.n.title");
            this.zzea = zzq2.zzp("gcm.n.title");
            this.zzeb = zzq2.zzn("gcm.n.title");
            this.zzec = zzq2.getString("gcm.n.body");
            this.zzed = zzq2.zzp("gcm.n.body");
            this.zzee = zzq2.zzn("gcm.n.body");
            this.zzef = zzq2.getString("gcm.n.icon");
            this.zzeg = zzq2.zzav();
            this.tag = zzq2.getString("gcm.n.tag");
            this.zzeh = zzq2.getString("gcm.n.color");
            this.zzei = zzq2.getString("gcm.n.click_action");
            this.zzej = zzq2.getString("gcm.n.android_channel_id");
            this.zzek = zzq2.zzaw();
        }

        @Nullable
        public String getTitle() {
            return this.zzdz;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzea;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzeb;
        }

        @Nullable
        public String getBody() {
            return this.zzec;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzed;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzee;
        }

        @Nullable
        public String getIcon() {
            return this.zzef;
        }

        @Nullable
        public String getSound() {
            return this.zzeg;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzeh;
        }

        @Nullable
        public String getClickAction() {
            return this.zzei;
        }

        @Nullable
        public String getChannelId() {
            return this.zzej;
        }

        @Nullable
        public Uri getLink() {
            return this.zzek;
        }
    }

    public static class Builder {
        private final Bundle zzdw = new Bundle();
        private final Map<String, String> zzdx = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.zzdw.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdx.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzdw);
            this.zzdw.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzdx.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdx.clear();
            this.zzdx.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdx.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.zzdw.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.zzdw.putString("message_type", string);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzdw.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.zzdw.putString("collapse_key", string);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

