/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

public final class RemoteMessage
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    Bundle mBundle;
    private Map<String, String> zzadY;
    private Notification zzckU;

    RemoteMessage(Bundle bundle) {
        this.mBundle = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Bundle)remoteMessage.mBundle, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final String getFrom() {
        return this.mBundle.getString("from");
    }

    public final String getTo() {
        return this.mBundle.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzadY == null) {
            this.zzadY = new ArrayMap();
            for (String string2 : this.mBundle.keySet()) {
                Object object = this.mBundle.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzadY.put(string2, string3);
            }
        }
        return this.zzadY;
    }

    public final String getCollapseKey() {
        return this.mBundle.getString("collapse_key");
    }

    public final String getMessageId() {
        String string2 = this.mBundle.getString("google.message_id");
        if (string2 == null) {
            string2 = this.mBundle.getString("message_id");
        }
        return string2;
    }

    public final String getMessageType() {
        return this.mBundle.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.mBundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.mBundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public final Notification getNotification() {
        if (this.zzckU == null && zza.zzG(this.mBundle)) {
            this.zzckU = new Notification(this.mBundle, null);
        }
        return this.zzckU;
    }

    public static class Notification {
        private final String zzaoy;
        private final String zzckV;
        private final String[] zzckW;
        private final String zzHF;
        private final String zzckX;
        private final String[] zzckY;
        private final String zzckZ;
        private final String zzcla;
        private final String mTag;
        private final String zzclb;
        private final String zzclc;
        private final Uri zzcld;

        private Notification(Bundle bundle) {
            this.zzaoy = zza.zze(bundle, "gcm.n.title");
            this.zzckV = zza.zzh(bundle, "gcm.n.title");
            this.zzckW = Notification.zzk(bundle, "gcm.n.title");
            this.zzHF = zza.zze(bundle, "gcm.n.body");
            this.zzckX = zza.zzh(bundle, "gcm.n.body");
            this.zzckY = Notification.zzk(bundle, "gcm.n.body");
            this.zzckZ = zza.zze(bundle, "gcm.n.icon");
            this.zzcla = zza.zzI(bundle);
            this.mTag = zza.zze(bundle, "gcm.n.tag");
            this.zzclb = zza.zze(bundle, "gcm.n.color");
            this.zzclc = zza.zze(bundle, "gcm.n.click_action");
            this.zzcld = zza.zzH(bundle);
        }

        private static String[] zzk(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzi(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzaoy;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzckV;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzckW;
        }

        @Nullable
        public String getBody() {
            return this.zzHF;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzckX;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzckY;
        }

        @Nullable
        public String getIcon() {
            return this.zzckZ;
        }

        @Nullable
        public String getSound() {
            return this.zzcla;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zzclb;
        }

        @Nullable
        public String getClickAction() {
            return this.zzclc;
        }

        @Nullable
        public Uri getLink() {
            return this.zzcld;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();
        private final Map<String, String> zzadY = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.mBundle.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzadY.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.mBundle);
            String string2 = FirebaseInstanceId.getInstance().getToken();
            if (string2 != null) {
                this.mBundle.putString("from", string2);
            } else {
                this.mBundle.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzadY.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzadY.clear();
            this.zzadY.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzadY.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.mBundle.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.mBundle.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(int n) {
            this.mBundle.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.mBundle.putString("collapse_key", string2);
            return this;
        }
    }
}

