/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

public final class RemoteMessage
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    Bundle mBundle;
    private Map<String, String> zzaea;
    private Notification zzcnS;

    RemoteMessage(Bundle bundle) {
        this.mBundle = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Bundle)remoteMessage.mBundle, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final String getFrom() {
        return this.mBundle.getString("from");
    }

    public final String getTo() {
        return this.mBundle.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzaea == null) {
            this.zzaea = new ArrayMap();
            for (String string2 : this.mBundle.keySet()) {
                Object object = this.mBundle.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzaea.put(string2, string3);
            }
        }
        return this.zzaea;
    }

    public final String getCollapseKey() {
        return this.mBundle.getString("collapse_key");
    }

    public final String getMessageId() {
        String string2 = this.mBundle.getString("google.message_id");
        if (string2 == null) {
            string2 = this.mBundle.getString("message_id");
        }
        return string2;
    }

    public final String getMessageType() {
        return this.mBundle.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.mBundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.mBundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public final Notification getNotification() {
        if (this.zzcnS == null && zza.zzG(this.mBundle)) {
            this.zzcnS = new Notification(this.mBundle, null);
        }
        return this.zzcnS;
    }

    public static class Notification {
        private final String zzaoA;
        private final String zzcnT;
        private final String[] zzcnU;
        private final String zzHG;
        private final String zzcnV;
        private final String[] zzcnW;
        private final String zzcnX;
        private final String zzcnY;
        private final String mTag;
        private final String zzcnZ;
        private final String zzcoa;
        private final Uri zzcob;

        private Notification(Bundle bundle) {
            this.zzaoA = zza.zze(bundle, "gcm.n.title");
            this.zzcnT = zza.zzh(bundle, "gcm.n.title");
            this.zzcnU = Notification.zzk(bundle, "gcm.n.title");
            this.zzHG = zza.zze(bundle, "gcm.n.body");
            this.zzcnV = zza.zzh(bundle, "gcm.n.body");
            this.zzcnW = Notification.zzk(bundle, "gcm.n.body");
            this.zzcnX = zza.zze(bundle, "gcm.n.icon");
            this.zzcnY = zza.zzI(bundle);
            this.mTag = zza.zze(bundle, "gcm.n.tag");
            this.zzcnZ = zza.zze(bundle, "gcm.n.color");
            this.zzcoa = zza.zze(bundle, "gcm.n.click_action");
            this.zzcob = zza.zzH(bundle);
        }

        private static String[] zzk(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzi(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzaoA;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzcnT;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzcnU;
        }

        @Nullable
        public String getBody() {
            return this.zzHG;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzcnV;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzcnW;
        }

        @Nullable
        public String getIcon() {
            return this.zzcnX;
        }

        @Nullable
        public String getSound() {
            return this.zzcnY;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zzcnZ;
        }

        @Nullable
        public String getClickAction() {
            return this.zzcoa;
        }

        @Nullable
        public Uri getLink() {
            return this.zzcob;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();
        private final Map<String, String> zzaea = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.mBundle.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzaea.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.mBundle);
            String string2 = FirebaseInstanceId.getInstance().getToken();
            if (string2 != null) {
                this.mBundle.putString("from", string2);
            } else {
                this.mBundle.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzaea.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzaea.clear();
            this.zzaea.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzaea.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.mBundle.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.mBundle.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(int n) {
            this.mBundle.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.mBundle.putString("collapse_key", string2);
            return this;
        }
    }
}

