/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzf;
import com.google.firebase.messaging.RemoteMessage;
import java.util.regex.Pattern;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final Pattern zzclM = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private static FirebaseMessaging zzclN;
    private final FirebaseInstanceId zzclk;

    public static synchronized FirebaseMessaging getInstance() {
        if (zzclN == null) {
            zzclN = new FirebaseMessaging(FirebaseInstanceId.getInstance());
        }
        return zzclN;
    }

    private FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        this.zzclk = firebaseInstanceId;
    }

    public void subscribeToTopic(String string2) {
        if (string2 != null && string2.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in subscribeToTopic.");
            string2 = string2.substring("/topics/".length());
        }
        if (string2 == null || !zzclM.matcher(string2).matches()) {
            String string3 = string2;
            String string4 = String.valueOf("[a-zA-Z0-9-_.~%]{1,900}");
            throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Invalid topic name: ").append(string3).append(" does not match the allowed format ").append(string4).toString());
        }
        String string5 = String.valueOf("S!");
        String string6 = String.valueOf(string2);
        this.zzclk.zzjt(string6.length() != 0 ? string5.concat(string6) : new String(string5));
    }

    public void unsubscribeFromTopic(String string2) {
        if (string2 != null && string2.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in unsubscribeFromTopic.");
            string2 = string2.substring("/topics/".length());
        }
        if (string2 == null || !zzclM.matcher(string2).matches()) {
            String string3 = string2;
            String string4 = String.valueOf("[a-zA-Z0-9-_.~%]{1,900}");
            throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Invalid topic name: ").append(string3).append(" does not match the allowed format ").append(string4).toString());
        }
        String string5 = String.valueOf("U!");
        String string6 = String.valueOf(string2);
        this.zzclk.zzjt(string6.length() != 0 ? string5.concat(string6) : new String(string5));
    }

    public void send(RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        String string2 = zzf.zzbA((Context)context);
        if (string2 == null) {
            Log.e((String)"FirebaseMessaging", (String)"Google Play services package is missing. Impossible to send message");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        zzf.zzf((Context)context, (Intent)intent);
        intent.setPackage(string2);
        remoteMessage.zzK(intent);
        context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }
}

