/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.directboot;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.CloudMessagingReceiver;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.FcmBroadcastProcessor;
import java.util.concurrent.ExecutionException;

public final class FirebaseMessagingDirectBootReceiver
extends CloudMessagingReceiver {
    static final String TAG = "FCM";

    @WorkerThread
    protected int onMessageReceive(@NonNull Context context, @NonNull CloudMessage message) {
        try {
            return (Integer)Tasks.await((Task)new FcmBroadcastProcessor(context).process(message.getIntent()));
        }
        catch (InterruptedException | ExecutionException e) {
            Log.e((String)TAG, (String)"Failed to send message to service.", (Throwable)e);
            return 500;
        }
    }
}

