/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.installations.CrossProcessLock;
import com.google.firebase.installations.FirebaseInstallations$$Lambda$1;
import com.google.firebase.installations.FirebaseInstallations$$Lambda$2;
import com.google.firebase.installations.FirebaseInstallations$$Lambda$3;
import com.google.firebase.installations.FirebaseInstallations$$Lambda$4;
import com.google.firebase.installations.FirebaseInstallations$$Lambda$5;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.FirebaseInstallationsException;
import com.google.firebase.installations.GetAuthTokenListener;
import com.google.firebase.installations.GetIdListener;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.installations.RandomFidGenerator;
import com.google.firebase.installations.StateListener;
import com.google.firebase.installations.Utils;
import com.google.firebase.installations.local.IidStore;
import com.google.firebase.installations.local.PersistedInstallation;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import com.google.firebase.installations.remote.FirebaseInstallationServiceClient;
import com.google.firebase.installations.remote.InstallationResponse;
import com.google.firebase.installations.remote.TokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FirebaseInstallations
implements FirebaseInstallationsApi {
    private final FirebaseApp firebaseApp;
    private final FirebaseInstallationServiceClient serviceClient;
    private final PersistedInstallation persistedInstallation;
    private final Utils utils;
    private final IidStore iidStore;
    private final RandomFidGenerator fidGenerator;
    private final Object lock = new Object();
    private final ExecutorService backgroundExecutor;
    private final ExecutorService networkExecutor;
    @GuardedBy(value="lock")
    private final List<StateListener> listeners = new ArrayList<StateListener>();
    private static final Object lockGenerateFid = new Object();
    private static final String LOCKFILE_NAME_GENERATE_FID = "generatefid.lock";
    private static final String CHIME_FIREBASE_APP_NAME = "CHIME_ANDROID_SDK";
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static final long KEEP_ALIVE_TIME_IN_SECONDS = 30L;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, String.format("firebase-installations-executor-%d", this.mCount.getAndIncrement()));
        }
    };

    FirebaseInstallations(FirebaseApp firebaseApp, @Nullable UserAgentPublisher publisher, @Nullable HeartBeatInfo heartbeatInfo) {
        this(new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY), firebaseApp, new FirebaseInstallationServiceClient(firebaseApp.getApplicationContext(), publisher, heartbeatInfo), new PersistedInstallation(firebaseApp), new Utils(), new IidStore(firebaseApp), new RandomFidGenerator());
    }

    FirebaseInstallations(ExecutorService backgroundExecutor, FirebaseApp firebaseApp, FirebaseInstallationServiceClient serviceClient, PersistedInstallation persistedInstallation, Utils utils, IidStore iidStore, RandomFidGenerator fidGenerator) {
        this.firebaseApp = firebaseApp;
        this.serviceClient = serviceClient;
        this.persistedInstallation = persistedInstallation;
        this.utils = utils;
        this.iidStore = iidStore;
        this.fidGenerator = fidGenerator;
        this.backgroundExecutor = backgroundExecutor;
        this.networkExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }

    private void preConditionChecks() {
        Preconditions.checkNotEmpty((String)this.getApplicationId());
        Preconditions.checkNotEmpty((String)this.getProjectIdentifier());
        Preconditions.checkNotEmpty((String)this.getApiKey());
        Preconditions.checkArgument((boolean)Utils.isValidAppIdFormat(this.getApplicationId()), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.");
        Preconditions.checkArgument((boolean)Utils.isValidApiKeyFormat(this.getApiKey()), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.Please refer to https://firebase.google.com/support/privacy/init-options.");
    }

    @Nullable
    String getProjectIdentifier() {
        return this.firebaseApp.getOptions().getProjectId();
    }

    @NonNull
    public static FirebaseInstallations getInstance() {
        FirebaseApp defaultFirebaseApp = FirebaseApp.getInstance();
        return FirebaseInstallations.getInstance(defaultFirebaseApp);
    }

    @NonNull
    public static FirebaseInstallations getInstance(@NonNull FirebaseApp app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null is not a valid value of FirebaseApp.");
        return (FirebaseInstallations)app.get(FirebaseInstallationsApi.class);
    }

    @VisibleForTesting
    String getApplicationId() {
        return this.firebaseApp.getOptions().getApplicationId();
    }

    @Nullable
    String getApiKey() {
        return this.firebaseApp.getOptions().getApiKey();
    }

    @VisibleForTesting
    String getName() {
        return this.firebaseApp.getName();
    }

    @NonNull
    public Task<String> getId() {
        this.preConditionChecks();
        Task<String> task = this.addGetIdListener();
        this.backgroundExecutor.execute(FirebaseInstallations$$Lambda$1.lambdaFactory$(this));
        return task;
    }

    @NonNull
    public Task<InstallationTokenResult> getToken(boolean forceRefresh) {
        this.preConditionChecks();
        Task<InstallationTokenResult> task = this.addGetAuthTokenListener();
        if (forceRefresh) {
            this.backgroundExecutor.execute(FirebaseInstallations$$Lambda$2.lambdaFactory$(this));
        } else {
            this.backgroundExecutor.execute(FirebaseInstallations$$Lambda$3.lambdaFactory$(this));
        }
        return task;
    }

    @NonNull
    public Task<Void> delete() {
        return Tasks.call((Executor)this.backgroundExecutor, (Callable)FirebaseInstallations$$Lambda$4.lambdaFactory$(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<String> addGetIdListener() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        GetIdListener l = new GetIdListener((TaskCompletionSource<String>)taskCompletionSource);
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(l);
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<InstallationTokenResult> addGetAuthTokenListener() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        GetAuthTokenListener l = new GetAuthTokenListener(this.utils, (TaskCompletionSource<InstallationTokenResult>)taskCompletionSource);
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(l);
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerOnStateReached(PersistedInstallationEntry persistedInstallationEntry) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<StateListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                StateListener l = it.next();
                boolean doneListening = l.onStateReached(persistedInstallationEntry);
                if (!doneListening) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerOnException(PersistedInstallationEntry prefs, Exception exception) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<StateListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                StateListener l = it.next();
                boolean doneListening = l.onException(prefs, exception);
                if (!doneListening) continue;
                it.remove();
            }
        }
    }

    private final void doGetId() {
        this.doRegistrationInternal(false);
    }

    private final void doGetAuthTokenWithoutForceRefresh() {
        this.doRegistrationInternal(false);
    }

    private final void doGetAuthTokenForceRefresh() {
        this.doRegistrationInternal(true);
    }

    private final void doRegistrationInternal(boolean forceRefresh) {
        PersistedInstallationEntry prefs = this.getPrefsWithGeneratedIdMultiProcessSafe();
        if (forceRefresh) {
            prefs = prefs.withClearedAuthToken();
        }
        this.triggerOnStateReached(prefs);
        this.networkExecutor.execute(FirebaseInstallations$$Lambda$5.lambdaFactory$(this, forceRefresh));
    }

    private void doNetworkCall(boolean forceRefresh) {
        PersistedInstallationEntry prefs;
        block8: {
            prefs = this.getPrefsWithGeneratedIdMultiProcessSafe();
            try {
                if (prefs.isErrored() || prefs.isUnregistered()) {
                    prefs = this.registerFidWithServer(prefs);
                    break block8;
                }
                if (forceRefresh || this.utils.isAuthTokenExpired(prefs)) {
                    prefs = this.fetchAuthTokenFromServer(prefs);
                    break block8;
                }
                return;
            }
            catch (IOException e) {
                this.triggerOnException(prefs, e);
                return;
            }
        }
        this.insertOrUpdatePrefs(prefs);
        if (prefs.isErrored()) {
            this.triggerOnException(prefs, (Exception)((Object)new FirebaseInstallationsException(FirebaseInstallationsException.Status.BAD_CONFIG)));
        } else if (prefs.isNotGenerated()) {
            this.triggerOnException(prefs, new IOException("cleared fid due to auth error"));
        } else {
            this.triggerOnStateReached(prefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdatePrefs(PersistedInstallationEntry prefs) {
        Object object = lockGenerateFid;
        synchronized (object) {
            CrossProcessLock lock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
            try {
                this.persistedInstallation.insertOrUpdatePersistedInstallationEntry(prefs);
            }
            finally {
                if (lock != null) {
                    lock.releaseAndClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistedInstallationEntry getPrefsWithGeneratedIdMultiProcessSafe() {
        Object object = lockGenerateFid;
        synchronized (object) {
            PersistedInstallationEntry persistedInstallationEntry;
            block8: {
                CrossProcessLock lock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
                try {
                    PersistedInstallationEntry prefs = this.persistedInstallation.readPersistedInstallationEntryValue();
                    if (prefs.isNotGenerated()) {
                        String fid = this.readExistingIidOrCreateFid(prefs);
                        prefs = this.persistedInstallation.insertOrUpdatePersistedInstallationEntry(prefs.withUnregisteredFid(fid));
                    }
                    persistedInstallationEntry = prefs;
                    if (lock == null) break block8;
                    lock.releaseAndClose();
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.releaseAndClose();
                    }
                    throw throwable;
                }
            }
            return persistedInstallationEntry;
        }
    }

    private String readExistingIidOrCreateFid(PersistedInstallationEntry prefs) {
        if (!this.firebaseApp.getName().equals(CHIME_FIREBASE_APP_NAME) && !this.firebaseApp.isDefaultApp() || !prefs.shouldAttemptMigration()) {
            return this.fidGenerator.createRandomFid();
        }
        String fid = this.iidStore.readIid();
        if (TextUtils.isEmpty((CharSequence)fid)) {
            fid = this.fidGenerator.createRandomFid();
        }
        return fid;
    }

    private PersistedInstallationEntry registerFidWithServer(PersistedInstallationEntry prefs) throws IOException {
        String iidToken = null;
        if (prefs.getFirebaseInstallationId().length() == 11) {
            iidToken = this.iidStore.readToken();
        }
        InstallationResponse response = this.serviceClient.createFirebaseInstallation(this.getApiKey(), prefs.getFirebaseInstallationId(), this.getProjectIdentifier(), this.getApplicationId(), iidToken);
        switch (response.getResponseCode()) {
            case OK: {
                return prefs.withRegisteredFid(response.getFid(), response.getRefreshToken(), this.utils.currentTimeInSecs(), response.getAuthToken().getToken(), response.getAuthToken().getTokenExpirationTimestamp());
            }
            case BAD_CONFIG: {
                return prefs.withFisError("BAD CONFIG");
            }
        }
        throw new IOException();
    }

    private PersistedInstallationEntry fetchAuthTokenFromServer(@NonNull PersistedInstallationEntry prefs) throws IOException {
        TokenResult tokenResult = this.serviceClient.generateAuthToken(this.getApiKey(), prefs.getFirebaseInstallationId(), this.getProjectIdentifier(), prefs.getRefreshToken());
        switch (tokenResult.getResponseCode()) {
            case OK: {
                return prefs.withAuthToken(tokenResult.getToken(), tokenResult.getTokenExpirationTimestamp(), this.utils.currentTimeInSecs());
            }
            case BAD_CONFIG: {
                return prefs.withFisError("BAD CONFIG");
            }
            case AUTH_ERROR: {
                return prefs.withNoGeneratedFid();
            }
        }
        throw new IOException();
    }

    private Void deleteFirebaseInstallationId() throws FirebaseInstallationsException, IOException {
        PersistedInstallationEntry entry = this.persistedInstallation.readPersistedInstallationEntryValue();
        if (entry.isRegistered()) {
            try {
                this.serviceClient.deleteFirebaseInstallation(this.getApiKey(), entry.getFirebaseInstallationId(), this.getProjectIdentifier(), entry.getRefreshToken());
            }
            catch (FirebaseException exception) {
                throw new FirebaseInstallationsException("Failed to delete a Firebase Installation.", FirebaseInstallationsException.Status.BAD_CONFIG);
            }
        }
        this.insertOrUpdatePrefs(entry.withNoGeneratedFid());
        return null;
    }

    static /* synthetic */ void lambda$doRegistrationInternal$0(FirebaseInstallations this_, boolean forceRefresh) {
        this_.doNetworkCall(forceRefresh);
    }

    static /* synthetic */ void access$lambda$0(FirebaseInstallations firebaseInstallations) {
        firebaseInstallations.doGetId();
    }

    static /* synthetic */ void access$lambda$1(FirebaseInstallations firebaseInstallations) {
        firebaseInstallations.doGetAuthTokenForceRefresh();
    }

    static /* synthetic */ void access$lambda$2(FirebaseInstallations firebaseInstallations) {
        firebaseInstallations.doGetAuthTokenWithoutForceRefresh();
    }

    static /* synthetic */ Void access$lambda$3(FirebaseInstallations firebaseInstallations) {
        return firebaseInstallations.deleteFirebaseInstallationId();
    }
}

