/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.remote;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.JsonReader;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseException;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.installations.FirebaseInstallationsException;
import com.google.firebase.installations.remote.InstallationResponse;
import com.google.firebase.installations.remote.TokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseInstallationServiceClient {
    private static final String FIREBASE_INSTALLATIONS_API_DOMAIN = "firebaseinstallations.googleapis.com";
    private static final String CREATE_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations";
    private static final String GENERATE_AUTH_TOKEN_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations/%s/authTokens:generate";
    private static final String DELETE_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations/%s";
    private static final String FIREBASE_INSTALLATIONS_API_VERSION = "v1";
    private static final String FIREBASE_INSTALLATION_AUTH_VERSION = "FIS_v2";
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String ACCEPT_HEADER_KEY = "Accept";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String CONTENT_ENCODING_HEADER_KEY = "Content-Encoding";
    private static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final String FIREBASE_INSTALLATIONS_ID_HEARTBEAT_TAG = "fire-installations-id";
    private static final String HEART_BEAT_HEADER = "x-firebase-client-log-type";
    private static final String USER_AGENT_HEADER = "x-firebase-client";
    private static final String X_ANDROID_PACKAGE_HEADER_KEY = "X-Android-Package";
    private static final String X_ANDROID_CERT_HEADER_KEY = "X-Android-Cert";
    private static final String X_ANDROID_IID_MIGRATION_KEY = "x-goog-fis-android-iid-migration-auth";
    private static final String API_KEY_HEADER = "x-goog-api-key";
    private static final int NETWORK_TIMEOUT_MILLIS = 10000;
    private static final Pattern EXPIRATION_TIMESTAMP_PATTERN = Pattern.compile("[0-9]+s");
    private static final int MAX_RETRIES = 1;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String SDK_VERSION_PREFIX = "a:";
    private static final String FIS_TAG = "Firebase-Installations";
    @VisibleForTesting
    static final String PARSING_EXPIRATION_TIME_ERROR_MESSAGE = "Invalid Expiration Timestamp.";
    private final Context context;
    private final UserAgentPublisher userAgentPublisher;
    private final HeartBeatInfo heartbeatInfo;

    public FirebaseInstallationServiceClient(@NonNull Context context, @Nullable UserAgentPublisher publisher, @Nullable HeartBeatInfo heartbeatInfo) {
        this.context = context;
        this.userAgentPublisher = publisher;
        this.heartbeatInfo = heartbeatInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public InstallationResponse createFirebaseInstallation(@NonNull String apiKey, @NonNull String fid, @NonNull String projectID, @NonNull String appId, @Nullable String iidToken) throws IOException {
        String resourceName = String.format(CREATE_REQUEST_RESOURCE_NAME_FORMAT, projectID);
        int retryCount = 0;
        URL url = new URL(String.format("https://%s/%s/%s", FIREBASE_INSTALLATIONS_API_DOMAIN, FIREBASE_INSTALLATIONS_API_VERSION, resourceName));
        while (retryCount <= 1) {
            HttpURLConnection httpURLConnection = this.openHttpURLConnection(url, apiKey);
            try {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                if (iidToken != null) {
                    httpURLConnection.addRequestProperty(X_ANDROID_IID_MIGRATION_KEY, iidToken);
                }
                this.writeFIDCreateRequestBodyToOutputStream(httpURLConnection, fid, appId);
                int httpResponseCode = httpURLConnection.getResponseCode();
                if (httpResponseCode == 200) {
                    InstallationResponse installationResponse = this.readCreateResponse(httpURLConnection);
                    return installationResponse;
                }
                FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection);
                if (httpResponseCode == 429 || httpResponseCode >= 500 && httpResponseCode < 600) {
                    ++retryCount;
                    continue;
                }
                FirebaseInstallationServiceClient.logBadConfigError();
                InstallationResponse installationResponse = InstallationResponse.builder().setResponseCode(InstallationResponse.ResponseCode.BAD_CONFIG).build();
                return installationResponse;
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        throw new IOException();
    }

    private void writeFIDCreateRequestBodyToOutputStream(HttpURLConnection httpURLConnection, @NonNull String fid, @NonNull String appId) throws IOException {
        FirebaseInstallationServiceClient.writeRequestBodyToOutputStream(httpURLConnection, FirebaseInstallationServiceClient.getJsonBytes(FirebaseInstallationServiceClient.buildCreateFirebaseInstallationRequestBody(fid, appId)));
    }

    private static byte[] getJsonBytes(JSONObject jsonObject) throws IOException {
        return jsonObject.toString().getBytes("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRequestBodyToOutputStream(URLConnection urlConnection, byte[] jsonBytes) throws IOException {
        OutputStream outputStream = urlConnection.getOutputStream();
        if (outputStream == null) {
            throw new IOException("Cannot send request to FIS servers. No OutputStream available.");
        }
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        try {
            gzipOutputStream.write(jsonBytes);
        }
        finally {
            try {
                gzipOutputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static JSONObject buildCreateFirebaseInstallationRequestBody(String fid, String appId) {
        try {
            JSONObject firebaseInstallationData = new JSONObject();
            firebaseInstallationData.put("fid", (Object)fid);
            firebaseInstallationData.put("appId", (Object)appId);
            firebaseInstallationData.put("authVersion", (Object)FIREBASE_INSTALLATION_AUTH_VERSION);
            firebaseInstallationData.put("sdkVersion", (Object)"a:16.2.2");
            return firebaseInstallationData;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private void writeGenerateAuthTokenRequestBodyToOutputStream(HttpURLConnection httpURLConnection) throws IOException {
        FirebaseInstallationServiceClient.writeRequestBodyToOutputStream(httpURLConnection, FirebaseInstallationServiceClient.getJsonBytes(FirebaseInstallationServiceClient.buildGenerateAuthTokenRequestBody()));
    }

    private static JSONObject buildGenerateAuthTokenRequestBody() {
        try {
            JSONObject sdkVersionData = new JSONObject();
            sdkVersionData.put("sdkVersion", (Object)"a:16.2.2");
            JSONObject firebaseInstallationData = new JSONObject();
            firebaseInstallationData.put("installation", (Object)sdkVersionData);
            return firebaseInstallationData;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    @NonNull
    public void deleteFirebaseInstallation(@NonNull String apiKey, @NonNull String fid, @NonNull String projectID, @NonNull String refreshToken) throws FirebaseException, IOException {
        String resourceName = String.format(DELETE_REQUEST_RESOURCE_NAME_FORMAT, projectID, fid);
        URL url = new URL(String.format("https://%s/%s/%s", FIREBASE_INSTALLATIONS_API_DOMAIN, FIREBASE_INSTALLATIONS_API_VERSION, resourceName));
        int retryCount = 0;
        while (retryCount <= 1) {
            HttpURLConnection httpURLConnection = this.openHttpURLConnection(url, apiKey);
            try {
                httpURLConnection.setRequestMethod("DELETE");
                httpURLConnection.addRequestProperty("Authorization", "FIS_v2 " + refreshToken);
                int httpResponseCode = httpURLConnection.getResponseCode();
                if (httpResponseCode == 200 || httpResponseCode == 401 || httpResponseCode == 404) {
                    return;
                }
                FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection);
                if (httpResponseCode == 429 || httpResponseCode >= 500 && httpResponseCode < 600) {
                    ++retryCount;
                    continue;
                }
                FirebaseInstallationServiceClient.logBadConfigError();
                throw new FirebaseInstallationsException("Bad config while trying to delete FID", FirebaseInstallationsException.Status.BAD_CONFIG);
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TokenResult generateAuthToken(@NonNull String apiKey, @NonNull String fid, @NonNull String projectID, @NonNull String refreshToken) throws IOException {
        String resourceName = String.format(GENERATE_AUTH_TOKEN_REQUEST_RESOURCE_NAME_FORMAT, projectID, fid);
        int retryCount = 0;
        URL url = new URL(String.format("https://%s/%s/%s", FIREBASE_INSTALLATIONS_API_DOMAIN, FIREBASE_INSTALLATIONS_API_VERSION, resourceName));
        while (retryCount <= 1) {
            HttpURLConnection httpURLConnection = this.openHttpURLConnection(url, apiKey);
            try {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.addRequestProperty("Authorization", "FIS_v2 " + refreshToken);
                this.writeGenerateAuthTokenRequestBodyToOutputStream(httpURLConnection);
                int httpResponseCode = httpURLConnection.getResponseCode();
                if (httpResponseCode == 200) {
                    TokenResult tokenResult = this.readGenerateAuthTokenResponse(httpURLConnection);
                    return tokenResult;
                }
                FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection);
                if (httpResponseCode == 401 || httpResponseCode == 404) {
                    TokenResult tokenResult = TokenResult.builder().setResponseCode(TokenResult.ResponseCode.AUTH_ERROR).build();
                    return tokenResult;
                }
                if (httpResponseCode == 429 || httpResponseCode >= 500 && httpResponseCode < 600) {
                    ++retryCount;
                    continue;
                }
                FirebaseInstallationServiceClient.logBadConfigError();
                TokenResult tokenResult = TokenResult.builder().setResponseCode(TokenResult.ResponseCode.BAD_CONFIG).build();
                return tokenResult;
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        throw new IOException();
    }

    private static void logBadConfigError() {
        Log.e((String)FIS_TAG, (String)"Firebase Installations can not communicate with Firebase server APIs due to invalid configuration. Please update your Firebase initialization process and set valid Firebase options (API key, Project ID, Application ID) when initializing Firebase.");
    }

    private HttpURLConnection openHttpURLConnection(URL url, String apiKey) throws IOException {
        HeartBeatInfo.HeartBeat heartbeat;
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(10000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_HEADER_KEY, JSON_CONTENT_TYPE);
        httpURLConnection.addRequestProperty(ACCEPT_HEADER_KEY, JSON_CONTENT_TYPE);
        httpURLConnection.addRequestProperty(CONTENT_ENCODING_HEADER_KEY, GZIP_CONTENT_ENCODING);
        httpURLConnection.addRequestProperty(X_ANDROID_PACKAGE_HEADER_KEY, this.context.getPackageName());
        if (this.heartbeatInfo != null && this.userAgentPublisher != null && (heartbeat = this.heartbeatInfo.getHeartBeatCode(FIREBASE_INSTALLATIONS_ID_HEARTBEAT_TAG)) != HeartBeatInfo.HeartBeat.NONE) {
            httpURLConnection.addRequestProperty(USER_AGENT_HEADER, this.userAgentPublisher.getUserAgent());
            httpURLConnection.addRequestProperty(HEART_BEAT_HEADER, Integer.toString(heartbeat.getCode()));
        }
        httpURLConnection.addRequestProperty(X_ANDROID_CERT_HEADER_KEY, this.getFingerprintHashForPackage());
        httpURLConnection.addRequestProperty(API_KEY_HEADER, apiKey);
        return httpURLConnection;
    }

    private InstallationResponse readCreateResponse(HttpURLConnection conn) throws IOException {
        InputStream inputStream = conn.getInputStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, UTF_8));
        TokenResult.Builder tokenResult = TokenResult.builder();
        InstallationResponse.Builder builder = InstallationResponse.builder();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("name")) {
                builder.setUri(reader.nextString());
                continue;
            }
            if (name.equals("fid")) {
                builder.setFid(reader.nextString());
                continue;
            }
            if (name.equals("refreshToken")) {
                builder.setRefreshToken(reader.nextString());
                continue;
            }
            if (name.equals("authToken")) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (key.equals("token")) {
                        tokenResult.setToken(reader.nextString());
                        continue;
                    }
                    if (key.equals("expiresIn")) {
                        tokenResult.setTokenExpirationTimestamp(FirebaseInstallationServiceClient.parseTokenExpirationTimestamp(reader.nextString()));
                        continue;
                    }
                    reader.skipValue();
                }
                builder.setAuthToken(tokenResult.build());
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        inputStream.close();
        return builder.setResponseCode(InstallationResponse.ResponseCode.OK).build();
    }

    private TokenResult readGenerateAuthTokenResponse(HttpURLConnection conn) throws IOException {
        InputStream inputStream = conn.getInputStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, UTF_8));
        TokenResult.Builder builder = TokenResult.builder();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("token")) {
                builder.setToken(reader.nextString());
                continue;
            }
            if (name.equals("expiresIn")) {
                builder.setTokenExpirationTimestamp(FirebaseInstallationServiceClient.parseTokenExpirationTimestamp(reader.nextString()));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        inputStream.close();
        return builder.setResponseCode(TokenResult.ResponseCode.OK).build();
    }

    private String getFingerprintHashForPackage() {
        try {
            byte[] hash = AndroidUtilsLight.getPackageCertificateHashBytes((Context)this.context, (String)this.context.getPackageName());
            if (hash == null) {
                Log.e((String)"ContentValues", (String)("Could not get fingerprint hash for package: " + this.context.getPackageName()));
                return null;
            }
            return Hex.bytesToStringUppercase((byte[])hash, (boolean)false);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"ContentValues", (String)("No such package: " + this.context.getPackageName()), (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static long parseTokenExpirationTimestamp(String expiresIn) {
        Preconditions.checkArgument((boolean)EXPIRATION_TIMESTAMP_PATTERN.matcher(expiresIn).matches(), (Object)PARSING_EXPIRATION_TIME_ERROR_MESSAGE);
        return expiresIn == null || expiresIn.length() == 0 ? 0L : Long.parseLong(expiresIn.substring(0, expiresIn.length() - 1));
    }

    private static void logFisCommunicationError(HttpURLConnection conn) {
        String logString = FirebaseInstallationServiceClient.readErrorResponse(conn);
        if (!TextUtils.isEmpty((CharSequence)logString)) {
            Log.w((String)FIS_TAG, (String)logString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readErrorResponse(HttpURLConnection conn) {
        InputStream errorStream = conn.getErrorStream();
        if (errorStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        try {
            StringBuilder response = new StringBuilder();
            String input = reader.readLine();
            while (input != null) {
                response.append(input).append('\n');
                input = reader.readLine();
            }
            String string = String.format("Error when communicating with the Firebase Installations server API. HTTP response: [%d %s: %s]", conn.getResponseCode(), conn.getResponseMessage(), response);
            return string;
        }
        catch (IOException ignored) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

