/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SetMutation
extends Mutation {
    private final ObjectValue value;

    public SetMutation(DocumentKey key, ObjectValue value, Precondition precondition) {
        this(key, value, precondition, new ArrayList<FieldTransform>());
    }

    public SetMutation(DocumentKey key, ObjectValue value, Precondition precondition, List<FieldTransform> fieldTransforms) {
        super(key, precondition, fieldTransforms);
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetMutation that = (SetMutation)o;
        return this.hasSameKeyAndPrecondition(that) && this.value.equals(that.value) && this.getFieldTransforms().equals(that.getFieldTransforms());
    }

    public int hashCode() {
        int result = this.keyAndPreconditionHashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "SetMutation{" + this.keyAndPreconditionToString() + ", value=" + this.value + "}";
    }

    @Override
    public void applyToRemoteDocument(MutableDocument document, MutationResult mutationResult) {
        this.verifyKeyMatches(document);
        ObjectValue newData = this.value.clone();
        Map<FieldPath, Value> transformResults = this.serverTransformResults(document, mutationResult.getTransformResults());
        newData.setAll(transformResults);
        document.convertToFoundDocument(mutationResult.getVersion(), newData).setHasCommittedMutations();
    }

    @Override
    public FieldMask applyToLocalView(MutableDocument document, @Nullable FieldMask previousMask, Timestamp localWriteTime) {
        this.verifyKeyMatches(document);
        if (!this.getPrecondition().isValidFor(document)) {
            return previousMask;
        }
        Map<FieldPath, Value> transformResults = this.localTransformResults(localWriteTime, document);
        ObjectValue localValue = this.value.clone();
        localValue.setAll(transformResults);
        document.convertToFoundDocument(document.getVersion(), localValue).setHasLocalMutations();
        return null;
    }

    @Override
    @Nullable
    public FieldMask getFieldMask() {
        return null;
    }

    public ObjectValue getValue() {
        return this.value;
    }
}

