/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.AutoValue_FieldIndex;
import com.google.firebase.firestore.model.AutoValue_FieldIndex_IndexOffset;
import com.google.firebase.firestore.model.AutoValue_FieldIndex_IndexState;
import com.google.firebase.firestore.model.AutoValue_FieldIndex_Segment;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

@AutoValue
public abstract class FieldIndex {
    public static final int UNKNOWN_ID = -1;
    public static final int INITIAL_LARGEST_BATCH_ID = -1;
    public static final int INITIAL_SEQUENCE_NUMBER = 0;
    public static IndexState INITIAL_STATE = IndexState.create(0L, IndexOffset.NONE);
    public static final Comparator<FieldIndex> SEMANTIC_COMPARATOR = (left, right) -> {
        int cmp = left.getCollectionGroup().compareTo(right.getCollectionGroup());
        if (cmp != 0) {
            return cmp;
        }
        Iterator<Segment> leftIt = left.getSegments().iterator();
        Iterator<Segment> rightIt = right.getSegments().iterator();
        while (leftIt.hasNext() && rightIt.hasNext()) {
            cmp = leftIt.next().compareTo(rightIt.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return Boolean.compare(leftIt.hasNext(), rightIt.hasNext());
    };

    public static FieldIndex create(int indexId, String collectionGroup, List<Segment> segments, IndexState indexState) {
        return new AutoValue_FieldIndex(indexId, collectionGroup, segments, indexState);
    }

    public abstract int getIndexId();

    public abstract String getCollectionGroup();

    public abstract List<Segment> getSegments();

    public abstract IndexState getIndexState();

    public List<Segment> getDirectionalSegments() {
        ArrayList<Segment> filteredSegments = new ArrayList<Segment>();
        for (Segment segment : this.getSegments()) {
            if (segment.getKind().equals((Object)Segment.Kind.CONTAINS)) continue;
            filteredSegments.add(segment);
        }
        return filteredSegments;
    }

    @Nullable
    public Segment getArraySegment() {
        for (Segment segment : this.getSegments()) {
            if (!segment.getKind().equals((Object)Segment.Kind.CONTAINS)) continue;
            return segment;
        }
        return null;
    }

    @AutoValue
    public static abstract class IndexOffset
    implements Comparable<IndexOffset> {
        public static final IndexOffset NONE = IndexOffset.create(SnapshotVersion.NONE, DocumentKey.empty(), -1);
        public static final Comparator<MutableDocument> DOCUMENT_COMPARATOR = (l, r) -> IndexOffset.fromDocument(l).compareTo(IndexOffset.fromDocument(r));

        public static IndexOffset create(SnapshotVersion readTime, DocumentKey key, int largestBatchId) {
            return new AutoValue_FieldIndex_IndexOffset(readTime, key, largestBatchId);
        }

        public static IndexOffset createSuccessor(SnapshotVersion readTime, int largestBatchId) {
            long successorSeconds = readTime.getTimestamp().getSeconds();
            int successorNanos = readTime.getTimestamp().getNanoseconds() + 1;
            SnapshotVersion successor = new SnapshotVersion((double)successorNanos == 1.0E9 ? new Timestamp(successorSeconds + 1L, 0) : new Timestamp(successorSeconds, successorNanos));
            return IndexOffset.create(successor, DocumentKey.empty(), largestBatchId);
        }

        public static IndexOffset fromDocument(Document document) {
            return IndexOffset.create(document.getReadTime(), document.getKey(), -1);
        }

        public abstract SnapshotVersion getReadTime();

        public abstract DocumentKey getDocumentKey();

        public abstract int getLargestBatchId();

        @Override
        public int compareTo(IndexOffset other) {
            int cmp = this.getReadTime().compareTo(other.getReadTime());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getDocumentKey().compareTo(other.getDocumentKey());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(this.getLargestBatchId(), other.getLargestBatchId());
        }
    }

    @AutoValue
    public static abstract class IndexState {
        public static IndexState create(long sequenceNumber, IndexOffset offset) {
            return new AutoValue_FieldIndex_IndexState(sequenceNumber, offset);
        }

        public static IndexState create(long sequenceNumber, SnapshotVersion readTime, DocumentKey documentKey, int largestBatchId) {
            return IndexState.create(sequenceNumber, IndexOffset.create(readTime, documentKey, largestBatchId));
        }

        public abstract long getSequenceNumber();

        public abstract IndexOffset getOffset();
    }

    @AutoValue
    public static abstract class Segment
    implements Comparable<Segment> {
        public static Segment create(FieldPath fieldPath, Kind kind) {
            return new AutoValue_FieldIndex_Segment(fieldPath, kind);
        }

        public abstract FieldPath getFieldPath();

        public abstract Kind getKind();

        @Override
        public int compareTo(Segment other) {
            int cmp = this.getFieldPath().compareTo(other.getFieldPath());
            if (cmp != 0) {
                return cmp;
            }
            return this.getKind().compareTo(other.getKind());
        }

        public static enum Kind {
            ASCENDING,
            DESCENDING,
            CONTAINS;

        }
    }
}

