/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.OverlayMigrationManager;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.util.Assert;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SQLiteOverlayMigrationManager
implements OverlayMigrationManager {
    private final SQLitePersistence db;

    public SQLiteOverlayMigrationManager(SQLitePersistence persistence) {
        this.db = persistence;
    }

    @Override
    public void run() {
        this.buildOverlays();
    }

    private void buildOverlays() {
        this.db.runTransaction("build overlays", () -> {
            if (!this.hasPendingOverlayMigration()) {
                return;
            }
            Set<String> userIds = this.getAllUserIds();
            RemoteDocumentCache remoteDocumentCache = this.db.getRemoteDocumentCache();
            for (String uid : userIds) {
                User user = new User(uid);
                MutationQueue mutationQueue = this.db.getMutationQueue(user, this.db.getIndexManager(user));
                HashSet<DocumentKey> allDocumentKeys = new HashSet<DocumentKey>();
                List<MutationBatch> batches = mutationQueue.getAllMutationBatches();
                for (MutationBatch batch : batches) {
                    allDocumentKeys.addAll(batch.getKeys());
                }
                DocumentOverlayCache documentOverlayCache = this.db.getDocumentOverlayCache(user);
                LocalDocumentsView localView = new LocalDocumentsView(remoteDocumentCache, mutationQueue, documentOverlayCache, this.db.getIndexManager(user));
                localView.recalculateAndSaveOverlays(allDocumentKeys);
            }
            this.removePendingOverlayMigrations();
        });
    }

    private Set<String> getAllUserIds() {
        HashSet<String> uids = new HashSet<String>();
        this.db.query("SELECT DISTINCT uid FROM mutation_queues").forEach(row -> uids.add(row.getString(0)));
        return uids;
    }

    @VisibleForTesting
    boolean hasPendingOverlayMigration() {
        Boolean[] result = new Boolean[]{false};
        this.db.query("SELECT migration_name FROM data_migrations").forEach(row -> {
            try {
                if (Persistence.DATA_MIGRATION_BUILD_OVERLAYS.equals(row.getString(0))) {
                    result[0] = true;
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                throw Assert.fail("SQLitePersistence.DataMigration failed to parse: %s", e);
            }
        });
        return result[0];
    }

    private void removePendingOverlayMigrations() {
        this.db.execute("DELETE FROM data_migrations WHERE migration_name = ?", Persistence.DATA_MIGRATION_BUILD_OVERLAYS);
    }
}

