/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.gms.common.api.internal.ActivityLifecycleObserver;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.firebase.firestore.LoadBundleTaskProgress;
import com.google.firebase.firestore.OnProgressListener;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;

public class LoadBundleTask
extends Task<LoadBundleTaskProgress> {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private LoadBundleTaskProgress snapshot = LoadBundleTaskProgress.INITIAL;
    private final TaskCompletionSource<LoadBundleTaskProgress> completionSource = new TaskCompletionSource();
    private final Task<LoadBundleTaskProgress> delegate = this.completionSource.getTask();
    @GuardedBy(value="lock")
    private final Queue<ManagedListener> progressListeners = new ArrayDeque<ManagedListener>();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LoadBundleTask() {
    }

    public boolean isComplete() {
        return this.delegate.isComplete();
    }

    public boolean isSuccessful() {
        return this.delegate.isSuccessful();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    @NonNull
    public LoadBundleTaskProgress getResult() {
        return (LoadBundleTaskProgress)this.delegate.getResult();
    }

    @NonNull
    public <X extends Throwable> LoadBundleTaskProgress getResult(@NonNull Class<X> exceptionType) throws X {
        return (LoadBundleTaskProgress)this.delegate.getResult(exceptionType);
    }

    @Nullable
    public Exception getException() {
        return this.delegate.getException();
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnSuccessListener(@NonNull OnSuccessListener<? super LoadBundleTaskProgress> onSuccessListener) {
        return this.delegate.addOnSuccessListener(onSuccessListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super LoadBundleTaskProgress> onSuccessListener) {
        return this.delegate.addOnSuccessListener(executor, onSuccessListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super LoadBundleTaskProgress> onSuccessListener) {
        return this.delegate.addOnSuccessListener(activity, onSuccessListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        return this.delegate.addOnFailureListener(onFailureListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        return this.delegate.addOnFailureListener(executor, onFailureListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        return this.delegate.addOnFailureListener(activity, onFailureListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnCompleteListener(@NonNull OnCompleteListener<LoadBundleTaskProgress> onCompleteListener) {
        return this.delegate.addOnCompleteListener(onCompleteListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<LoadBundleTaskProgress> onCompleteListener) {
        return this.delegate.addOnCompleteListener(executor, onCompleteListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<LoadBundleTaskProgress> onCompleteListener) {
        return this.delegate.addOnCompleteListener(activity, onCompleteListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnCanceledListener(@NonNull OnCanceledListener onCanceledListener) {
        return this.delegate.addOnCanceledListener(onCanceledListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnCanceledListener(@NonNull Executor executor, @NonNull OnCanceledListener onCanceledListener) {
        return this.delegate.addOnCanceledListener(executor, onCanceledListener);
    }

    @NonNull
    public Task<LoadBundleTaskProgress> addOnCanceledListener(@NonNull Activity activity, @NonNull OnCanceledListener onCanceledListener) {
        return this.delegate.addOnCanceledListener(activity, onCanceledListener);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<LoadBundleTaskProgress, TContinuationResult> continuation) {
        return this.delegate.continueWith(continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<LoadBundleTaskProgress, TContinuationResult> continuation) {
        return this.delegate.continueWith(executor, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<LoadBundleTaskProgress, Task<TContinuationResult>> continuation) {
        return this.delegate.continueWithTask(continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<LoadBundleTaskProgress, Task<TContinuationResult>> continuation) {
        return this.delegate.continueWithTask(executor, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull SuccessContinuation<LoadBundleTaskProgress, TContinuationResult> successContinuation) {
        return this.delegate.onSuccessTask(successContinuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull Executor executor, @NonNull SuccessContinuation<LoadBundleTaskProgress, TContinuationResult> successContinuation) {
        return this.delegate.onSuccessTask(executor, successContinuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LoadBundleTask addOnProgressListener(@NonNull OnProgressListener<LoadBundleTaskProgress> listener) {
        ManagedListener managedListener = new ManagedListener(null, listener);
        Object object = this.lock;
        synchronized (object) {
            this.progressListeners.add(managedListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LoadBundleTask addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<LoadBundleTaskProgress> listener) {
        ManagedListener managedListener = new ManagedListener(executor, listener);
        Object object = this.lock;
        synchronized (object) {
            this.progressListeners.add(managedListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LoadBundleTask addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<LoadBundleTaskProgress> listener) {
        ManagedListener managedListener = new ManagedListener(null, listener);
        Object object = this.lock;
        synchronized (object) {
            this.progressListeners.add(managedListener);
        }
        ActivityLifecycleObserver.of((Activity)activity).onStopCallOnce(() -> this.removeOnProgressListener(listener));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOnProgressListener(@NonNull OnProgressListener<LoadBundleTaskProgress> listener) {
        Object object = this.lock;
        synchronized (object) {
            this.progressListeners.remove(new ManagedListener(null, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setResult(@NonNull LoadBundleTaskProgress result) {
        Assert.hardAssert(result.getTaskState().equals((Object)LoadBundleTaskProgress.TaskState.SUCCESS), "Expected success, but was " + (Object)((Object)result.getTaskState()), new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            this.snapshot = result;
            for (ManagedListener listener : this.progressListeners) {
                listener.invokeAsync(this.snapshot);
            }
            this.progressListeners.clear();
        }
        this.completionSource.setResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setException(@NonNull Exception exception) {
        Object object = this.lock;
        synchronized (object) {
            LoadBundleTaskProgress snapshot;
            this.snapshot = snapshot = new LoadBundleTaskProgress(this.snapshot.getDocumentsLoaded(), this.snapshot.getTotalDocuments(), this.snapshot.getBytesLoaded(), this.snapshot.getTotalBytes(), exception, LoadBundleTaskProgress.TaskState.ERROR);
            for (ManagedListener listener : this.progressListeners) {
                listener.invokeAsync(snapshot);
            }
            this.progressListeners.clear();
        }
        this.completionSource.setException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateProgress(@NonNull LoadBundleTaskProgress progressUpdate) {
        Object object = this.lock;
        synchronized (object) {
            this.snapshot = progressUpdate;
            for (ManagedListener listener : this.progressListeners) {
                listener.invokeAsync(progressUpdate);
            }
        }
    }

    private static class ManagedListener {
        Executor executor;
        OnProgressListener<LoadBundleTaskProgress> listener;

        ManagedListener(@Nullable Executor executor, OnProgressListener<LoadBundleTaskProgress> listener) {
            this.executor = executor != null ? executor : TaskExecutors.MAIN_THREAD;
            this.listener = listener;
        }

        public void invokeAsync(LoadBundleTaskProgress snapshot) {
            this.executor.execute(() -> this.listener.onProgress(snapshot));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManagedListener that = (ManagedListener)o;
            return this.listener.equals(that.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

