/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.dynamiclinks.internal.DynamicLinkData;

public class PendingDynamicLinkData {
    private final DynamicLinkData zzi;

    @KeepForSdk
    @VisibleForTesting
    public PendingDynamicLinkData(DynamicLinkData dynamicLinkData) {
        if (dynamicLinkData == null) {
            this.zzi = null;
            return;
        }
        if (dynamicLinkData.getClickTimestamp() == 0L) {
            long l = DefaultClock.getInstance().currentTimeMillis();
            dynamicLinkData.zza(l);
        }
        this.zzi = dynamicLinkData;
    }

    protected PendingDynamicLinkData(@Nullable String string, int n, long l, @Nullable Uri uri) {
        this.zzi = new DynamicLinkData(null, string, n, l, null, uri);
    }

    @KeepForSdk
    @ShowFirstParty
    @Nullable
    public Bundle getExtensions() {
        if (this.zzi == null) {
            return new Bundle();
        }
        return this.zzi.zzf();
    }

    @Nullable
    public Uri getLink() {
        if (this.zzi == null) {
            return null;
        }
        String string = this.zzi.zzd();
        if (string != null) {
            return Uri.parse((String)string);
        }
        return null;
    }

    public int getMinimumAppVersion() {
        if (this.zzi == null) {
            return 0;
        }
        return this.zzi.zze();
    }

    public long getClickTimestamp() {
        if (this.zzi == null) {
            return 0L;
        }
        return this.zzi.getClickTimestamp();
    }

    @VisibleForTesting
    private final Uri zzc() {
        if (this.zzi == null) {
            return null;
        }
        return this.zzi.zzc();
    }

    @Nullable
    public Intent getUpdateAppIntent(@NonNull Context context) {
        int n;
        if (this.getMinimumAppVersion() == 0) {
            return null;
        }
        try {
            n = context.getPackageManager().getPackageInfo((String)context.getApplicationContext().getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        if (n < this.getMinimumAppVersion() && this.zzc() != null) {
            return new Intent("android.intent.action.VIEW").setData(this.zzc()).setPackage("com.android.vending");
        }
        return null;
    }
}

