/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.internal.zze;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zze;

    DynamicLink(Bundle bundle) {
        this.zze = bundle;
    }

    @NonNull
    public final Uri getUri() {
        Bundle bundle = this.zze;
        com.google.firebase.dynamiclinks.internal.zze.zzb(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            Uri uri2 = Uri.parse((String)bundle.getString("domainUriPrefix"));
            builder.scheme(uri2.getScheme());
            builder.authority(uri2.getAuthority());
            builder.path(uri2.getPath());
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class NavigationInfoParameters {
        final Bundle zzf;

        private NavigationInfoParameters(Bundle bundle) {
            this.zzf = bundle;
        }

        /* synthetic */ NavigationInfoParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzf = new Bundle();

            @NonNull
            public final Builder setForcedRedirectEnabled(boolean bl) {
                this.zzf.putInt("efr", bl ? 1 : 0);
                return this;
            }

            public final boolean getForcedRedirectEnabled() {
                return this.zzf.getInt("efr") == 1;
            }

            @NonNull
            public final NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.zzf, null);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzf;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzf = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzf = new Bundle();

            @NonNull
            public final Builder setTitle(@NonNull String string) {
                this.zzf.putString("st", string);
                return this;
            }

            @NonNull
            public final String getTitle() {
                return this.zzf.getString("st", "");
            }

            @NonNull
            public final Builder setDescription(@NonNull String string) {
                this.zzf.putString("sd", string);
                return this;
            }

            @NonNull
            public final String getDescription() {
                return this.zzf.getString("sd", "");
            }

            @NonNull
            public final Builder setImageUrl(@NonNull Uri uri) {
                this.zzf.putParcelable("si", (Parcelable)uri);
                return this;
            }

            @NonNull
            public final Uri getImageUrl() {
                Uri uri = (Uri)this.zzf.getParcelable("si");
                if (uri == null) {
                    uri = Uri.EMPTY;
                }
                return uri;
            }

            @NonNull
            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzf, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzf;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzf = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzf = new Bundle();

            @NonNull
            public final Builder setProviderToken(@NonNull String string) {
                this.zzf.putString("pt", string);
                return this;
            }

            @NonNull
            public final String getProviderToken() {
                return this.zzf.getString("pt", "");
            }

            @NonNull
            public final Builder setAffiliateToken(@NonNull String string) {
                this.zzf.putString("at", string);
                return this;
            }

            @NonNull
            public final String getAffiliateToken() {
                return this.zzf.getString("at", "");
            }

            @NonNull
            public final Builder setCampaignToken(@NonNull String string) {
                this.zzf.putString("ct", string);
                return this;
            }

            @NonNull
            public final String getCampaignToken() {
                return this.zzf.getString("ct", "");
            }

            @NonNull
            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzf, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzf;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzf = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzf = new Bundle();

            public Builder() {
            }

            public Builder(@NonNull String string, @NonNull String string2, @NonNull String string3) {
                this.zzf.putString("utm_source", string);
                this.zzf.putString("utm_medium", string2);
                this.zzf.putString("utm_campaign", string3);
            }

            @NonNull
            public final Builder setSource(@NonNull String string) {
                this.zzf.putString("utm_source", string);
                return this;
            }

            @NonNull
            public final String getSource() {
                return this.zzf.getString("utm_source", "");
            }

            @NonNull
            public final Builder setMedium(@NonNull String string) {
                this.zzf.putString("utm_medium", string);
                return this;
            }

            @NonNull
            public final String getMedium() {
                return this.zzf.getString("utm_medium", "");
            }

            @NonNull
            public final Builder setCampaign(@NonNull String string) {
                this.zzf.putString("utm_campaign", string);
                return this;
            }

            @NonNull
            public final String getCampaign() {
                return this.zzf.getString("utm_campaign", "");
            }

            @NonNull
            public final Builder setTerm(@NonNull String string) {
                this.zzf.putString("utm_term", string);
                return this;
            }

            @NonNull
            public final String getTerm() {
                return this.zzf.getString("utm_term", "");
            }

            @NonNull
            public final Builder setContent(@NonNull String string) {
                this.zzf.putString("utm_content", string);
                return this;
            }

            @NonNull
            public final String getContent() {
                return this.zzf.getString("utm_content", "");
            }

            @NonNull
            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzf, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzf;

        private IosParameters(Bundle bundle) {
            this.zzf = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzf = new Bundle();

            public Builder(@NonNull String string) {
                this.zzf.putString("ibi", string);
            }

            @NonNull
            public final Builder setFallbackUrl(@NonNull Uri uri) {
                this.zzf.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            @NonNull
            public final Builder setCustomScheme(@NonNull String string) {
                this.zzf.putString("ius", string);
                return this;
            }

            @NonNull
            public final String getCustomScheme() {
                return this.zzf.getString("ius", "");
            }

            @NonNull
            public final Builder setIpadFallbackUrl(@NonNull Uri uri) {
                this.zzf.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            @NonNull
            public final Uri getIpadFallbackUrl() {
                Uri uri = (Uri)this.zzf.getParcelable("ipfl");
                if (uri == null) {
                    uri = Uri.EMPTY;
                }
                return uri;
            }

            @NonNull
            public final Builder setIpadBundleId(@NonNull String string) {
                this.zzf.putString("ipbi", string);
                return this;
            }

            @NonNull
            public final String getIpadBundleId() {
                return this.zzf.getString("ipbi", "");
            }

            @NonNull
            public final Builder setAppStoreId(@NonNull String string) {
                this.zzf.putString("isi", string);
                return this;
            }

            @NonNull
            public final String getAppStoreId() {
                return this.zzf.getString("isi", "");
            }

            @NonNull
            public final Builder setMinimumVersion(@NonNull String string) {
                this.zzf.putString("imv", string);
                return this;
            }

            @NonNull
            public final String getMinimumVersion() {
                return this.zzf.getString("imv", "");
            }

            @NonNull
            public final IosParameters build() {
                return new IosParameters(this.zzf, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzf;

        private AndroidParameters(Bundle bundle) {
            this.zzf = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzf;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzf = new Bundle();
                this.zzf.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzf = new Bundle();
                this.zzf.putString("apn", string);
            }

            @NonNull
            public final Builder setFallbackUrl(@NonNull Uri uri) {
                this.zzf.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            @NonNull
            public final Uri getFallbackUrl() {
                Uri uri = (Uri)this.zzf.getParcelable("afl");
                if (uri == null) {
                    uri = Uri.EMPTY;
                }
                return uri;
            }

            @NonNull
            public final Builder setMinimumVersion(int n) {
                this.zzf.putInt("amv", n);
                return this;
            }

            public final int getMinimumVersion() {
                return this.zzf.getInt("amv");
            }

            @NonNull
            public final AndroidParameters build() {
                return new AndroidParameters(this.zzf, null);
            }
        }
    }

    public static final class Builder {
        private final zze zzg;
        private final Bundle zze;
        private final Bundle zzh;

        public Builder(zze zze2) {
            this.zzg = zze2;
            this.zze = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zze.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzh = new Bundle();
            this.zze.putBundle("parameters", this.zzh);
        }

        @NonNull
        public final Builder setLongLink(@NonNull Uri uri) {
            this.zze.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        @NonNull
        public final Uri getLongLink() {
            Uri uri = (Uri)this.zzh.getParcelable("dynamicLink");
            if (uri == null) {
                uri = Uri.EMPTY;
            }
            return uri;
        }

        @NonNull
        public final Builder setLink(@NonNull Uri uri) {
            this.zzh.putParcelable("link", (Parcelable)uri);
            return this;
        }

        @NonNull
        public final Uri getLink() {
            Uri uri = (Uri)this.zzh.getParcelable("link");
            if (uri == null) {
                uri = Uri.EMPTY;
            }
            return uri;
        }

        @Deprecated
        @NonNull
        public final Builder setDynamicLinkDomain(@NonNull String string) {
            if (!string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.app\\.goo\\.gl$") && !string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.page\\.link$")) {
                throw new IllegalArgumentException("Use setDomainUriPrefix() instead, setDynamicLinkDomain() is only applicable for *.page.link and *.app.goo.gl domains.");
            }
            this.zze.putString("domain", string);
            String string2 = String.valueOf("https://");
            String string3 = String.valueOf(string);
            this.zze.putString("domainUriPrefix", string3.length() != 0 ? string2.concat(string3) : new String(string2));
            return this;
        }

        @NonNull
        public final Builder setDomainUriPrefix(@NonNull String string) {
            if (string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.app\\.goo\\.gl$") || string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.page\\.link$")) {
                this.zze.putString("domain", string.replace("https://", ""));
            }
            this.zze.putString("domainUriPrefix", string);
            return this;
        }

        @NonNull
        public final String getDomainUriPrefix() {
            return this.zze.getString("domainUriPrefix", "");
        }

        @NonNull
        public final Builder setAndroidParameters(@NonNull AndroidParameters androidParameters) {
            this.zzh.putAll(androidParameters.zzf);
            return this;
        }

        @NonNull
        public final Builder setIosParameters(@NonNull IosParameters iosParameters) {
            this.zzh.putAll(iosParameters.zzf);
            return this;
        }

        @NonNull
        public final Builder setGoogleAnalyticsParameters(@NonNull GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzh.putAll(googleAnalyticsParameters.zzf);
            return this;
        }

        @NonNull
        public final Builder setItunesConnectAnalyticsParameters(@NonNull ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzh.putAll(itunesConnectAnalyticsParameters.zzf);
            return this;
        }

        @NonNull
        public final Builder setSocialMetaTagParameters(@NonNull SocialMetaTagParameters socialMetaTagParameters) {
            this.zzh.putAll(socialMetaTagParameters.zzf);
            return this;
        }

        @NonNull
        public final Builder setNavigationInfoParameters(@NonNull NavigationInfoParameters navigationInfoParameters) {
            this.zzh.putAll(navigationInfoParameters.zzf);
            return this;
        }

        @NonNull
        public final DynamicLink buildDynamicLink() {
            com.google.firebase.dynamiclinks.internal.zze.zzb(this.zze);
            return new DynamicLink(this.zze);
        }

        @NonNull
        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzb();
            return this.zzg.zza(this.zze);
        }

        @NonNull
        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzb();
            this.zze.putInt("suffix", n);
            return this.zzg.zza(this.zze);
        }

        private final void zzb() {
            if (this.zze.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

