/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.dynamiclinks.DynamicLink;
import com.google.firebase.dynamiclinks.FirebaseDynamicLinks;
import com.google.firebase.dynamiclinks.PendingDynamicLinkData;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.internal.zza;
import com.google.firebase.dynamiclinks.internal.zzc;
import com.google.firebase.dynamiclinks.internal.zzj;
import com.google.firebase.dynamiclinks.internal.zzl;

public final class zzg
extends FirebaseDynamicLinks {
    private final GoogleApi<Api.ApiOptions.NoOptions> zzag;
    @Nullable
    private final AnalyticsConnector zzah;

    public zzg(FirebaseApp firebaseApp, @Nullable AnalyticsConnector analyticsConnector) {
        this(new zzc(firebaseApp.getApplicationContext()), analyticsConnector);
    }

    @VisibleForTesting
    private zzg(GoogleApi<Api.ApiOptions.NoOptions> googleApi, @Nullable AnalyticsConnector analyticsConnector) {
        this.zzag = googleApi;
        this.zzah = analyticsConnector;
        if (analyticsConnector == null) {
            Log.w((String)"FDL", (String)"FDL logging failed. Add a dependency for Firebase Analytics to your app to enable logging of Dynamic Link events.");
        }
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Intent intent) {
        Task task = this.zzag.doWrite((TaskApiCall)new zzl(this.zzah, intent.getDataString()));
        zza zza2 = (zza)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.firebase.dynamiclinks.DYNAMIC_LINK_DATA", zza.CREATOR);
        PendingDynamicLinkData pendingDynamicLinkData = zza2 != null ? new PendingDynamicLinkData(zza2) : null;
        if (pendingDynamicLinkData != null) {
            task = Tasks.forResult((Object)pendingDynamicLinkData);
        }
        return task;
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Uri uri) {
        return this.zzag.doWrite((TaskApiCall)new zzl(this.zzah, uri.toString()));
    }

    @Override
    public final DynamicLink.Builder createDynamicLink() {
        return new DynamicLink.Builder(this);
    }

    public final Task<ShortDynamicLink> zza(Bundle bundle) {
        zzg.zzb(bundle);
        return this.zzag.doWrite((TaskApiCall)new zzj(bundle));
    }

    public static void zzb(Bundle bundle) {
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (TextUtils.isEmpty((CharSequence)bundle.getString("domainUriPrefix")) && uri == null) {
            throw new IllegalArgumentException("FDL domain is missing. Set with setDomainUriPrefix() or setDynamicLinkDomain().");
        }
    }
}

