/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.SyncTree;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Node;
import java.util.ArrayList;

abstract class ValueProvider {
    ValueProvider() {
    }

    public abstract ValueProvider getImmediateChild(ChildKey var1);

    public abstract Node node();

    public static class DeferredValueProvider
    extends ValueProvider {
        private final SyncTree syncTree;
        private final Path path;

        DeferredValueProvider(SyncTree syncTree, Path path) {
            this.syncTree = syncTree;
            this.path = path;
        }

        @Override
        public ValueProvider getImmediateChild(ChildKey childKey) {
            Path child = this.path.child(childKey);
            return new DeferredValueProvider(this.syncTree, child);
        }

        @Override
        public Node node() {
            return this.syncTree.calcCompleteEventCache(this.path, new ArrayList<Long>());
        }
    }

    public static class ExistingValueProvider
    extends ValueProvider {
        private final Node node;

        ExistingValueProvider(Node node) {
            this.node = node;
        }

        @Override
        public ValueProvider getImmediateChild(ChildKey childKey) {
            Node child = this.node.getImmediateChild(childKey);
            return new ExistingValueProvider(child);
        }

        @Override
        public Node node() {
            return this.node;
        }
    }
}

