/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.Node;
import java.util.HashMap;
import java.util.Map;

class SparseSnapshotTree {
    private Node value = null;
    private Map<ChildKey, SparseSnapshotTree> children = null;

    public void remember(Path path, Node data) {
        if (path.isEmpty()) {
            this.value = data;
            this.children = null;
        } else if (this.value != null) {
            this.value = this.value.updateChild(path, data);
        } else {
            ChildKey childKey;
            if (this.children == null) {
                this.children = new HashMap<ChildKey, SparseSnapshotTree>();
            }
            if (!this.children.containsKey(childKey = path.getFront())) {
                this.children.put(childKey, new SparseSnapshotTree());
            }
            SparseSnapshotTree child = this.children.get(childKey);
            child.remember(path.popFront(), data);
        }
    }

    public boolean forget(final Path path) {
        if (path.isEmpty()) {
            this.value = null;
            this.children = null;
            return true;
        }
        if (this.value != null) {
            if (this.value.isLeafNode()) {
                return false;
            }
            ChildrenNode childrenNode = (ChildrenNode)this.value;
            this.value = null;
            childrenNode.forEachChild(new ChildrenNode.ChildVisitor(){

                @Override
                public void visitChild(ChildKey name, Node child) {
                    SparseSnapshotTree.this.remember(path.child(name), child);
                }
            });
            return this.forget(path);
        }
        if (this.children != null) {
            SparseSnapshotTree child;
            boolean safeToRemove;
            ChildKey childKey = path.getFront();
            Path childPath = path.popFront();
            if (this.children.containsKey(childKey) && (safeToRemove = (child = this.children.get(childKey)).forget(childPath))) {
                this.children.remove(childKey);
            }
            if (this.children.isEmpty()) {
                this.children = null;
                return true;
            }
            return false;
        }
        return true;
    }

    public void forEachTree(final Path prefixPath, final SparseSnapshotTreeVisitor visitor) {
        if (this.value != null) {
            visitor.visitTree(prefixPath, this.value);
        } else {
            this.forEachChild(new SparseSnapshotChildVisitor(){

                @Override
                public void visitChild(ChildKey key, SparseSnapshotTree tree) {
                    tree.forEachTree(prefixPath.child(key), visitor);
                }
            });
        }
    }

    public void forEachChild(SparseSnapshotChildVisitor visitor) {
        if (this.children != null) {
            for (Map.Entry<ChildKey, SparseSnapshotTree> entry : this.children.entrySet()) {
                visitor.visitChild(entry.getKey(), entry.getValue());
            }
        }
    }

    public static interface SparseSnapshotTreeVisitor {
        public void visitTree(Path var1, Node var2);
    }

    public static interface SparseSnapshotChildVisitor {
        public void visitChild(ChildKey var1, SparseSnapshotTree var2);
    }
}

