/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.android;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.database.core.TokenProvider;
import com.google.firebase.inject.Deferred;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class AndroidAuthTokenProvider
implements TokenProvider {
    private final Deferred<InternalAuthProvider> deferredAuthProvider;
    private final AtomicReference<InternalAuthProvider> internalAuth;

    public AndroidAuthTokenProvider(Deferred<InternalAuthProvider> deferredAuthProvider) {
        this.deferredAuthProvider = deferredAuthProvider;
        this.internalAuth = new AtomicReference();
        deferredAuthProvider.whenAvailable(authProvider -> this.internalAuth.set((InternalAuthProvider)authProvider.get()));
    }

    @Override
    @SuppressLint(value={"TaskMainThread"})
    public void getToken(boolean forceRefresh, @NonNull TokenProvider.GetTokenCompletionListener listener2) {
        InternalAuthProvider authProvider = this.internalAuth.get();
        if (authProvider != null) {
            Task getTokenResult = authProvider.getAccessToken(forceRefresh);
            getTokenResult.addOnSuccessListener(result -> listener2.onSuccess(result.getToken())).addOnFailureListener(e -> {
                if (AndroidAuthTokenProvider.isUnauthenticatedUsage(e)) {
                    listener2.onSuccess(null);
                } else {
                    listener2.onError(e.getMessage());
                }
            });
        } else {
            listener2.onSuccess(null);
        }
    }

    @Override
    public void addTokenChangeListener(ExecutorService executorService, TokenProvider.TokenChangeListener tokenListener) {
        this.deferredAuthProvider.whenAvailable(provider -> ((InternalAuthProvider)provider.get()).addIdTokenListener(tokenResult -> executorService.execute(() -> tokenListener.onTokenChange(tokenResult.getToken()))));
    }

    @Override
    public void removeTokenChangeListener(TokenProvider.TokenChangeListener tokenListener) {
    }

    private static boolean isUnauthenticatedUsage(Exception e) {
        return e instanceof FirebaseApiNotAvailableException || e instanceof FirebaseNoSignedInUserException;
    }
}

