/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.utilities;

import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.utilities.Validation;
import java.util.Random;

public class PushIdGenerator {
    private static final String PUSH_CHARS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    private static final char MIN_PUSH_CHAR = '-';
    private static final char MAX_PUSH_CHAR = 'z';
    private static final int MAX_KEY_LEN = 786;
    private static final Random randGen = new Random();
    private static long lastPushTime = 0L;
    private static final int[] lastRandChars = new int[12];

    public static synchronized String generatePushChildName(long now) {
        int i;
        boolean duplicateTime = now == lastPushTime;
        lastPushTime = now;
        char[] timeStampChars = new char[8];
        StringBuilder result = new StringBuilder(20);
        for (i = 7; i >= 0; --i) {
            timeStampChars[i] = PUSH_CHARS.charAt((int)(now % 64L));
            now /= 64L;
        }
        Utilities.hardAssert(now == 0L);
        result.append(timeStampChars);
        if (!duplicateTime) {
            for (i = 0; i < 12; ++i) {
                PushIdGenerator.lastRandChars[i] = randGen.nextInt(64);
            }
        } else {
            PushIdGenerator.incrementArray();
        }
        for (i = 0; i < 12; ++i) {
            result.append(PUSH_CHARS.charAt(lastRandChars[i]));
        }
        Utilities.hardAssert(result.length() == 20);
        return result.toString();
    }

    public static final String predecessor(String key) {
        Validation.validateNullableKey(key);
        Integer num = Utilities.tryParseInt(key);
        if (num != null) {
            if (num == Integer.MIN_VALUE) {
                return "[MIN_NAME]";
            }
            return String.valueOf(num - 1);
        }
        StringBuilder next = new StringBuilder(key);
        if (next.charAt(next.length() - 1) == '-') {
            if (next.length() == 1) {
                return String.valueOf(Integer.MAX_VALUE);
            }
            return next.substring(0, next.length() - 1);
        }
        next.setCharAt(next.length() - 1, PUSH_CHARS.charAt(PUSH_CHARS.indexOf(next.charAt(next.length() - 1)) - 1));
        return next.append(new String(new char[786 - next.length()]).replace("\u0000", "z")).toString();
    }

    public static final String successor(String key) {
        int i;
        Validation.validateNullableKey(key);
        Integer num = Utilities.tryParseInt(key);
        if (num != null) {
            if (num == Integer.MAX_VALUE) {
                return String.valueOf('-');
            }
            return String.valueOf(num + 1);
        }
        StringBuilder next = new StringBuilder(key);
        if (next.length() < 786) {
            next.append('-');
            return next.toString();
        }
        for (i = next.length() - 1; i >= 0 && next.charAt(i) == 'z'; --i) {
        }
        if (i == -1) {
            return "[MAX_KEY]";
        }
        char source = next.charAt(i);
        char sourcePlusOne = PUSH_CHARS.charAt(PUSH_CHARS.indexOf(source) + 1);
        next.replace(i, i + 1, String.valueOf(sourcePlusOne));
        return next.substring(0, i + 1);
    }

    private static void incrementArray() {
        for (int i = 11; i >= 0; --i) {
            if (lastRandChars[i] != 63) {
                PushIdGenerator.lastRandChars[i] = lastRandChars[i] + 1;
                return;
            }
            PushIdGenerator.lastRandChars[i] = 0;
        }
    }
}

