/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.annotations.NotNull;
import com.google.firebase.database.core.EventRegistrationZombieListener;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.DataEvent;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.core.view.QuerySpec;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EventRegistration {
    private AtomicBoolean zombied = new AtomicBoolean(false);
    private EventRegistrationZombieListener listener;
    private boolean isUserInitiated = false;

    public abstract boolean respondsTo(Event.EventType var1);

    public abstract DataEvent createEvent(Change var1, QuerySpec var2);

    public abstract void fireEvent(DataEvent var1);

    public abstract void fireCancelEvent(DatabaseError var1);

    public abstract EventRegistration clone(QuerySpec var1);

    public abstract boolean isSameListener(EventRegistration var1);

    @NotNull
    public abstract QuerySpec getQuerySpec();

    public void zombify() {
        if (this.zombied.compareAndSet(false, true) && this.listener != null) {
            this.listener.onZombied(this);
            this.listener = null;
        }
    }

    public boolean isZombied() {
        return this.zombied.get();
    }

    public void setOnZombied(EventRegistrationZombieListener listener) {
        Utilities.hardAssert(!this.isZombied());
        Utilities.hardAssert(this.listener == null);
        this.listener = listener;
    }

    public boolean isUserInitiated() {
        return this.isUserInitiated;
    }

    public void setIsUserInitiated(boolean isUserInitiated) {
        this.isUserInitiated = isUserInitiated;
    }

    Repo getRepo() {
        return null;
    }
}

