/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.utilities;

public class Pair<T, U> {
    private final T first;
    private final U second;

    public Pair(T first, U second) {
        this.first = first;
        this.second = second;
    }

    public T getFirst() {
        return this.first;
    }

    public U getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.first != null ? !this.first.equals(pair.first) : pair.first != null) {
            return false;
        }
        return !(this.second != null ? !this.second.equals(pair.second) : pair.second != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair(" + this.first + "," + this.second + ")";
    }
}

