/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.android;

import android.support.annotation.NonNull;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class AndroidAuthTokenProvider
implements AuthTokenProvider {
    private final ScheduledExecutorService executorService;
    private final FirebaseApp firebaseApp;

    public AndroidAuthTokenProvider(@NonNull FirebaseApp firebaseApp, @NonNull ScheduledExecutorService executorService) {
        this.firebaseApp = firebaseApp;
        this.executorService = executorService;
    }

    @Override
    public void getToken(boolean forceRefresh, final @NonNull AuthTokenProvider.GetTokenCompletionListener listener) {
        Task getTokenResult = this.firebaseApp.getToken(forceRefresh);
        getTokenResult.addOnSuccessListener((Executor)this.executorService, (OnSuccessListener)new OnSuccessListener<GetTokenResult>(){

            public void onSuccess(GetTokenResult result) {
                listener.onSuccess(result.getToken());
            }
        }).addOnFailureListener((Executor)this.executorService, new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                if (this.isUnauthenticatedUsage(e)) {
                    listener.onSuccess(null);
                } else {
                    listener.onError(e.getMessage());
                }
            }

            private boolean isUnauthenticatedUsage(Exception e) {
                return e instanceof FirebaseApiNotAvailableException || e instanceof FirebaseNoSignedInUserException;
            }
        });
    }

    @Override
    public void addTokenChangeListener(AuthTokenProvider.TokenChangeListener tokenListener) {
        FirebaseApp.IdTokenListener idTokenListener = this.produceIdTokenListener(tokenListener);
        this.firebaseApp.addIdTokenListener(idTokenListener);
    }

    private FirebaseApp.IdTokenListener produceIdTokenListener(final AuthTokenProvider.TokenChangeListener tokenListener) {
        return new FirebaseApp.IdTokenListener(){

            public void onIdTokenChanged(final @NonNull InternalTokenResult tokenResult) {
                AndroidAuthTokenProvider.this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        tokenListener.onTokenChange(tokenResult.getToken());
                    }
                });
            }
        };
    }

    @Override
    public void removeTokenChangeListener(AuthTokenProvider.TokenChangeListener tokenListener) {
    }
}

