/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzees;
import com.google.android.gms.internal.zzemm;
import com.google.android.gms.internal.zzeod;
import com.google.android.gms.internal.zzeof;
import com.google.android.gms.internal.zzeog;
import com.google.android.gms.internal.zzeoh;
import com.google.android.gms.internal.zzeoi;
import com.google.android.gms.internal.zzeoj;
import com.google.android.gms.internal.zzeok;
import com.google.android.gms.internal.zzeol;
import com.google.android.gms.internal.zzeon;
import com.google.android.gms.internal.zzeoo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class zzeoe {
    private static final AtomicInteger zznpu = new AtomicInteger(0);
    private static final Charset zznpv = Charset.forName("UTF-8");
    private volatile int zznpw = zzeoi.zznqh;
    private volatile Socket socket = null;
    private zzeoj zznpx = null;
    private final URI zznpy;
    @Nullable
    private final String zznaa;
    private final zzeon zznpz;
    private final zzeoo zznqa;
    private final zzeol zznqb;
    private final zzemm zzmxz;
    private final int zzfug = zznpu.incrementAndGet();
    private final Thread zznqc = zznqd.newThread(new zzeog(this));
    private static ThreadFactory zznqd = Executors.defaultThreadFactory();
    private static zzeod zznqe = new zzeof();

    static ThreadFactory getThreadFactory() {
        return zznqd;
    }

    static zzeod zzcdb() {
        return zznqe;
    }

    public zzeoe(zzees zzees2, URI uRI, String string, Map<String, String> map) {
        this.zznpy = uRI;
        this.zznaa = zzees2.zzbwp();
        int n = this.zzfug;
        this.zzmxz = new zzemm(zzees2.zzbwk(), "WebSocket", new StringBuilder(14).append("sk_").append(n).toString());
        this.zznqb = new zzeol(uRI, null, map);
        this.zznpz = new zzeon(this);
        this.zznqa = new zzeoo(this, "TubeSock", this.zzfug);
    }

    public final void zza(zzeoj zzeoj2) {
        this.zznpx = zzeoj2;
    }

    final zzeoj zzcdc() {
        return this.zznpx;
    }

    public final synchronized void connect() {
        if (this.zznpw != zzeoi.zznqh) {
            this.zznpx.zza(new zzeok("connect() already called"));
            this.close();
            return;
        }
        int n = this.zzfug;
        zznqe.zza(this.zznqc, new StringBuilder(26).append("TubeSockReader-").append(n).toString());
        this.zznpw = zzeoi.zznqi;
        this.zznqc.start();
    }

    public final synchronized void zzpy(String string) {
        this.zza((byte)1, string.getBytes(zznpv));
    }

    final synchronized void zzaq(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zznpw != zzeoi.zznqj) {
            this.zznpx.zza(new zzeok("error while sending data: not connected"));
            return;
        }
        try {
            this.zznqa.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zznpx.zza(new zzeok("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzeok zzeok2) {
        this.zznpx.zza(zzeok2);
        if (this.zznpw == zzeoi.zznqj) {
            this.close();
        }
        this.zzcde();
    }

    public final synchronized void close() {
        switch (zzeoh.zznqg[this.zznpw - 1]) {
            case 1: {
                this.zznpw = zzeoi.zznql;
                return;
            }
            case 2: {
                this.zzcde();
                return;
            }
            case 3: {
                zzeoe zzeoe2 = this;
                try {
                    zzeoe2.zznpw = zzeoi.zznqk;
                    zzeoe2.zznqa.zzcdl();
                    zzeoe2.zznqa.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzeoe2.zznpx.zza(new zzeok("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzcdd() {
        this.zzcde();
    }

    private final synchronized void zzcde() {
        if (this.zznpw == zzeoi.zznql) {
            return;
        }
        this.zznpz.zzcdj();
        this.zznqa.zzcdl();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zznpw = zzeoi.zznql;
        this.zznpx.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zznpy.getScheme();
        String string2 = this.zznpy.getHost();
        int n = this.zznpy.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzeok(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zznpy);
                throw new zzeok(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        }
        if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            SSLSessionCache sSLSessionCache = null;
            try {
                if (this.zznaa != null) {
                    sSLSessionCache = new SSLSessionCache(new File(this.zznaa));
                }
            }
            catch (IOException iOException) {
                this.zzmxz.zzb("Failed to initialize SSL session cache", iOException, new Object[0]);
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLCertificateSocketFactory.getDefault((int)60000, sSLSessionCache).createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zznpy);
                    throw new zzeok(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzeok(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zznpy);
                throw new zzeok(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        }
        String string8 = String.valueOf(string);
        throw new zzeok(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        return socket;
    }

    public final void zzcdf() throws InterruptedException {
        if (this.zznqa.zzcdn().getState() != Thread.State.NEW) {
            this.zznqa.zzcdn().join();
        }
        this.zznqc.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzcdg() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zznpw == zzeoi.zznql) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zznqb.zzcdh());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzeok("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zznpv);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zznpv);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzeok(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzeok(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzeok("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzeok("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzeok(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzeok("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzeok("connection failed: missing header field in server handshake: Connection");
            }
            this.zznqa.zzb(outputStream);
            this.zznpz.zza((DataInputStream)object);
            this.zznpw = zzeoi.zznqj;
            this.zznqa.zzcdn().start();
            this.zznpx.zzbxp();
            this.zznpz.run();
            return;
        }
        catch (zzeok zzeok2) {
            this.zznpx.zza(zzeok2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zznpx.zza(new zzeok(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzeoe zzeoe2) {
        zzeoe2.zzcdg();
    }
}

