/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedMapIterator;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.zzd;
import com.google.firebase.database.collection.zze;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public final class zzc<K, V>
extends ImmutableSortedMap<K, V> {
    private LLRBNode<K, V> zzt;
    private Comparator<K> zzc;

    private zzc(LLRBNode<K, V> lLRBNode, Comparator<K> comparator) {
        this.zzt = lLRBNode;
        this.zzc = comparator;
    }

    private final LLRBNode<K, V> zzc(K k) {
        LLRBNode<K, V> lLRBNode = this.zzt;
        while (!lLRBNode.isEmpty()) {
            int n = this.zzc.compare(k, lLRBNode.getKey());
            if (n < 0) {
                lLRBNode = lLRBNode.getLeft();
                continue;
            }
            if (n == 0) {
                return lLRBNode;
            }
            lLRBNode = lLRBNode.getRight();
        }
        return null;
    }

    @Override
    public final boolean containsKey(K k) {
        return this.zzc(k) != null;
    }

    @Override
    public final V get(K k) {
        LLRBNode<K, V> lLRBNode = this.zzc(k);
        if (lLRBNode != null) {
            return lLRBNode.getValue();
        }
        return null;
    }

    @Override
    public final ImmutableSortedMap<K, V> remove(K k) {
        if (!((ImmutableSortedMap)this).containsKey(k)) {
            return this;
        }
        LLRBNode<Object, Object> lLRBNode = this.zzt.remove(k, this.zzc).copy(null, null, LLRBNode.Color.zzo, null, null);
        return new zzc<Object, Object>(lLRBNode, this.zzc);
    }

    @Override
    public final ImmutableSortedMap<K, V> insert(K k, V v) {
        LLRBNode<Object, Object> lLRBNode = this.zzt.insert(k, v, this.zzc).copy(null, null, LLRBNode.Color.zzo, null, null);
        return new zzc<Object, Object>(lLRBNode, this.zzc);
    }

    @Override
    public final K getMinKey() {
        return this.zzt.getMin().getKey();
    }

    @Override
    public final K getMaxKey() {
        return this.zzt.getMax().getKey();
    }

    @Override
    public final int size() {
        return this.zzt.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.zzt.isEmpty();
    }

    @Override
    public final void inOrderTraversal(LLRBNode.NodeVisitor<K, V> nodeVisitor) {
        this.zzt.inOrderTraversal(nodeVisitor);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return new ImmutableSortedMapIterator<Object, V>(this.zzt, null, this.zzc, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iteratorFrom(K k) {
        return new ImmutableSortedMapIterator<K, V>(this.zzt, k, this.zzc, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> reverseIteratorFrom(K k) {
        return new ImmutableSortedMapIterator<K, V>(this.zzt, k, this.zzc, true);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> reverseIterator() {
        return new ImmutableSortedMapIterator<Object, V>(this.zzt, null, this.zzc, true);
    }

    @Override
    public final K getPredecessorKey(K k) {
        LLRBNode<K, V> lLRBNode = this.zzt;
        LLRBNode<K, V> lLRBNode2 = null;
        while (!lLRBNode.isEmpty()) {
            int n = this.zzc.compare(k, lLRBNode.getKey());
            if (n == 0) {
                if (!lLRBNode.getLeft().isEmpty()) {
                    lLRBNode = lLRBNode.getLeft();
                    while (!lLRBNode.getRight().isEmpty()) {
                        lLRBNode = lLRBNode.getRight();
                    }
                    return lLRBNode.getKey();
                }
                if (lLRBNode2 != null) {
                    return lLRBNode2.getKey();
                }
                return null;
            }
            if (n < 0) {
                lLRBNode = lLRBNode.getLeft();
                continue;
            }
            lLRBNode2 = lLRBNode;
            lLRBNode = lLRBNode.getRight();
        }
        String string = String.valueOf(k);
        throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(string).length()).append("Couldn't find predecessor key of non-present key: ").append(string).toString());
    }

    @Override
    public final K getSuccessorKey(K k) {
        LLRBNode<K, V> lLRBNode = this.zzt;
        LLRBNode<K, V> lLRBNode2 = null;
        while (!lLRBNode.isEmpty()) {
            int n = this.zzc.compare(lLRBNode.getKey(), k);
            if (n == 0) {
                if (!lLRBNode.getRight().isEmpty()) {
                    lLRBNode = lLRBNode.getRight();
                    while (!lLRBNode.getLeft().isEmpty()) {
                        lLRBNode = lLRBNode.getLeft();
                    }
                    return lLRBNode.getKey();
                }
                if (lLRBNode2 != null) {
                    return lLRBNode2.getKey();
                }
                return null;
            }
            if (n < 0) {
                lLRBNode = lLRBNode.getRight();
                continue;
            }
            lLRBNode2 = lLRBNode;
            lLRBNode = lLRBNode.getLeft();
        }
        String string = String.valueOf(k);
        throw new IllegalArgumentException(new StringBuilder(48 + String.valueOf(string).length()).append("Couldn't find successor key of non-present key: ").append(string).toString());
    }

    @Override
    public final int indexOf(K k) {
        int n = 0;
        LLRBNode<K, V> lLRBNode = this.zzt;
        while (!lLRBNode.isEmpty()) {
            int n2 = this.zzc.compare(k, lLRBNode.getKey());
            if (n2 == 0) {
                return n + lLRBNode.getLeft().size();
            }
            if (n2 < 0) {
                lLRBNode = lLRBNode.getLeft();
                continue;
            }
            n += lLRBNode.getLeft().size() + 1;
            lLRBNode = lLRBNode.getRight();
        }
        return -1;
    }

    @Override
    public final Comparator<K> getComparator() {
        return this.zzc;
    }

    public static <A, B> zzc<A, B> zzb(Map<A, B> map, Comparator<A> comparator) {
        return zze.zzb(new ArrayList<A>(map.keySet()), map, ImmutableSortedMap.Builder.identityTranslator(), comparator);
    }

    /* synthetic */ zzc(LLRBNode lLRBNode, Comparator comparator, zzd zzd2) {
        this(lLRBNode, comparator);
    }
}

