/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.database.collection.ImmutableSortedMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@KeepForSdk
public class ImmutableSortedSet<T>
implements Iterable<T> {
    private final ImmutableSortedMap<T, Void> zzk;

    @KeepForSdk
    public ImmutableSortedSet(List<T> list, Comparator<T> comparator) {
        this.zzk = ImmutableSortedMap.Builder.buildFrom(list, Collections.emptyMap(), ImmutableSortedMap.Builder.identityTranslator(), comparator);
    }

    private ImmutableSortedSet(ImmutableSortedMap<T, Void> immutableSortedMap) {
        this.zzk = immutableSortedMap;
    }

    @KeepForSdk
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImmutableSortedSet)) {
            return false;
        }
        ImmutableSortedSet immutableSortedSet = (ImmutableSortedSet)object;
        return this.zzk.equals(immutableSortedSet.zzk);
    }

    @KeepForSdk
    public int hashCode() {
        return this.zzk.hashCode();
    }

    @KeepForSdk
    public boolean contains(T t) {
        return this.zzk.containsKey(t);
    }

    @KeepForSdk
    public ImmutableSortedSet<T> remove(T t) {
        ImmutableSortedMap<T, Void> immutableSortedMap = this.zzk.remove(t);
        if (immutableSortedMap == this.zzk) {
            return this;
        }
        return new ImmutableSortedSet<T>(immutableSortedMap);
    }

    @KeepForSdk
    public ImmutableSortedSet<T> insert(T t) {
        return new ImmutableSortedSet<T>(this.zzk.insert(t, null));
    }

    @KeepForSdk
    public T getMinEntry() {
        return this.zzk.getMinKey();
    }

    @KeepForSdk
    public T getMaxEntry() {
        return this.zzk.getMaxKey();
    }

    @KeepForSdk
    public int size() {
        return this.zzk.size();
    }

    @KeepForSdk
    public boolean isEmpty() {
        return this.zzk.isEmpty();
    }

    @Override
    @KeepForSdk
    public Iterator<T> iterator() {
        return new WrappedEntryIterator<T>(this.zzk.iterator());
    }

    @KeepForSdk
    public Iterator<T> iteratorFrom(T t) {
        return new WrappedEntryIterator<T>(this.zzk.iteratorFrom(t));
    }

    @KeepForSdk
    public Iterator<T> reverseIteratorFrom(T t) {
        return new WrappedEntryIterator<T>(this.zzk.reverseIteratorFrom(t));
    }

    @KeepForSdk
    public Iterator<T> reverseIterator() {
        return new WrappedEntryIterator<T>(this.zzk.reverseIterator());
    }

    @KeepForSdk
    public T getPredecessorEntry(T t) {
        return this.zzk.getPredecessorKey(t);
    }

    @KeepForSdk
    public int indexOf(T t) {
        return this.zzk.indexOf(t);
    }

    private static class WrappedEntryIterator<T>
    implements Iterator<T> {
        private final Iterator<Map.Entry<T, Void>> zzl;

        @KeepForSdk
        public WrappedEntryIterator(Iterator<Map.Entry<T, Void>> iterator) {
            this.zzl = iterator;
        }

        @Override
        @KeepForSdk
        public boolean hasNext() {
            return this.zzl.hasNext();
        }

        @Override
        @KeepForSdk
        public T next() {
            return this.zzl.next().getKey();
        }

        @Override
        @KeepForSdk
        public void remove() {
            this.zzl.remove();
        }
    }
}

