/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.zza;
import com.google.firebase.database.collection.zzc;
import com.google.firebase.database.collection.zze;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@KeepForSdk
public abstract class ImmutableSortedMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    @KeepForSdk
    public abstract boolean containsKey(K var1);

    @KeepForSdk
    public abstract V get(K var1);

    @KeepForSdk
    public abstract ImmutableSortedMap<K, V> remove(K var1);

    @KeepForSdk
    public abstract ImmutableSortedMap<K, V> insert(K var1, V var2);

    @KeepForSdk
    public abstract K getMinKey();

    @KeepForSdk
    public abstract K getMaxKey();

    @KeepForSdk
    public abstract int size();

    @KeepForSdk
    public abstract boolean isEmpty();

    @KeepForSdk
    public abstract void inOrderTraversal(LLRBNode.NodeVisitor<K, V> var1);

    @Override
    @KeepForSdk
    public abstract Iterator<Map.Entry<K, V>> iterator();

    @KeepForSdk
    public abstract Iterator<Map.Entry<K, V>> iteratorFrom(K var1);

    @KeepForSdk
    public abstract Iterator<Map.Entry<K, V>> reverseIteratorFrom(K var1);

    @KeepForSdk
    public abstract Iterator<Map.Entry<K, V>> reverseIterator();

    @KeepForSdk
    public abstract K getPredecessorKey(K var1);

    @KeepForSdk
    public abstract K getSuccessorKey(K var1);

    @KeepForSdk
    public abstract int indexOf(K var1);

    @KeepForSdk
    public abstract Comparator<K> getComparator();

    @KeepForSdk
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImmutableSortedMap)) {
            return false;
        }
        ImmutableSortedMap immutableSortedMap = (ImmutableSortedMap)object;
        if (!this.getComparator().equals(immutableSortedMap.getComparator())) {
            return false;
        }
        if (this.size() != immutableSortedMap.size()) {
            return false;
        }
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        Iterator<Map.Entry<K, V>> iterator2 = immutableSortedMap.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @KeepForSdk
    public int hashCode() {
        int n = this.getComparator().hashCode();
        for (Map.Entry<K, V> entry : this) {
            n = n * 31 + entry.hashCode();
        }
        return n;
    }

    @KeepForSdk
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("{");
        boolean bl = true;
        for (Map.Entry<K, V> entry : this) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("(");
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=>");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(")");
        }
        stringBuilder.append("};");
        return stringBuilder.toString();
    }

    @KeepForSdk
    public static class Builder {
        private static final KeyTranslator<?, ?> zzh = new KeyTranslator(){

            @KeepForSdk
            public Object translate(Object object) {
                return object;
            }
        };

        @KeepForSdk
        public static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<K> comparator) {
            return new zza(comparator);
        }

        @KeepForSdk
        public static <A> KeyTranslator<A, A> identityTranslator() {
            return zzh;
        }

        @KeepForSdk
        public static <A, B> ImmutableSortedMap<A, B> fromMap(Map<A, B> map, Comparator<A> comparator) {
            if (map.size() < 25) {
                return zza.zza(map, comparator);
            }
            return zzc.zzb(map, comparator);
        }

        @KeepForSdk
        public static <A, B, C> ImmutableSortedMap<A, C> buildFrom(List<A> list, Map<B, C> map, KeyTranslator<A, B> keyTranslator, Comparator<A> comparator) {
            if (list.size() < 25) {
                return zza.zza(list, map, keyTranslator, comparator);
            }
            Comparator<A> comparator2 = comparator;
            KeyTranslator<A, B> keyTranslator2 = keyTranslator;
            Map<B, C> map2 = map;
            return zze.zzb(list, map2, keyTranslator2, comparator2);
        }

        @KeepForSdk
        public static interface KeyTranslator<C, D> {
            @KeepForSdk
            public D translate(C var1);
        }
    }
}

