/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.persistence;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.ProcessDetailsProvider;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileStore {
    private static final String CRASHLYTICS_PATH_V1 = ".com.google.firebase.crashlytics.files.v1";
    private static final String CRASHLYTICS_PATH_V2 = ".com.google.firebase.crashlytics.files.v2";
    private static final String CRASHLYTICS_PATH_V3 = ".crashlytics.v3";
    private static final String SESSIONS_PATH = "open-sessions";
    private static final String NATIVE_SESSION_SUBDIR = "native";
    private static final String REPORTS_PATH = "reports";
    private static final String PRIORITY_REPORTS_PATH = "priority-reports";
    private static final String NATIVE_REPORTS_PATH = "native-reports";
    final String processName;
    private final File filesDir;
    private final File crashlyticsDir;
    private final File sessionsDir;
    private final File reportsDir;
    private final File priorityReportsDir;
    private final File nativeReportsDir;

    public FileStore(Context context) {
        this.processName = ProcessDetailsProvider.INSTANCE.getCurrentProcessDetails(context).getProcessName();
        this.filesDir = context.getFilesDir();
        String crashlyticsPath = this.useV3FileSystem() ? CRASHLYTICS_PATH_V3 + File.separator + FileStore.sanitizeName(this.processName) : CRASHLYTICS_PATH_V1;
        this.crashlyticsDir = FileStore.prepareBaseDir(new File(this.filesDir, crashlyticsPath));
        this.sessionsDir = FileStore.prepareBaseDir(new File(this.crashlyticsDir, SESSIONS_PATH));
        this.reportsDir = FileStore.prepareBaseDir(new File(this.crashlyticsDir, REPORTS_PATH));
        this.priorityReportsDir = FileStore.prepareBaseDir(new File(this.crashlyticsDir, PRIORITY_REPORTS_PATH));
        this.nativeReportsDir = FileStore.prepareBaseDir(new File(this.crashlyticsDir, NATIVE_REPORTS_PATH));
    }

    @VisibleForTesting
    public void deleteAllCrashlyticsFiles() {
        FileStore.recursiveDelete(this.crashlyticsDir);
    }

    public void cleanupPreviousFileSystems() {
        this.cleanupFileSystemDir(".com.google.firebase.crashlytics");
        this.cleanupFileSystemDir(".com.google.firebase.crashlytics-ndk");
        if (this.useV3FileSystem()) {
            this.cleanupFileSystemDir(CRASHLYTICS_PATH_V1);
            this.cleanupFileSystemDirs(CRASHLYTICS_PATH_V2 + File.pathSeparator);
        }
    }

    private void cleanupFileSystemDir(String child) {
        File dir = new File(this.filesDir, child);
        if (dir.exists() && FileStore.recursiveDelete(dir)) {
            Logger.getLogger().d("Deleted previous Crashlytics file system: " + dir.getPath());
        }
    }

    private void cleanupFileSystemDirs(String prefix) {
        String[] list;
        if (this.filesDir.exists() && (list = this.filesDir.list((dir, name) -> name.startsWith(prefix))) != null) {
            for (String child : list) {
                this.cleanupFileSystemDir(child);
            }
        }
    }

    static boolean recursiveDelete(File fileOrDirectory) {
        File[] files = fileOrDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                FileStore.recursiveDelete(file);
            }
        }
        return fileOrDirectory.delete();
    }

    public File getCommonFile(String filename) {
        return new File(this.crashlyticsDir, filename);
    }

    public List<File> getCommonFiles(FilenameFilter filter) {
        return FileStore.safeArrayToList(this.crashlyticsDir.listFiles(filter));
    }

    private File getSessionDir(String sessionId) {
        return FileStore.prepareDir(new File(this.sessionsDir, sessionId));
    }

    public File getSessionFile(String sessionId, String filename) {
        return new File(this.getSessionDir(sessionId), filename);
    }

    public List<File> getSessionFiles(String sessionId, FilenameFilter filter) {
        return FileStore.safeArrayToList(this.getSessionDir(sessionId).listFiles(filter));
    }

    public File getNativeSessionDir(String sessionId) {
        return FileStore.prepareDir(new File(this.getSessionDir(sessionId), NATIVE_SESSION_SUBDIR));
    }

    public boolean deleteSessionFiles(String sessionId) {
        File sessionDir = new File(this.sessionsDir, sessionId);
        return FileStore.recursiveDelete(sessionDir);
    }

    public List<String> getAllOpenSessionIds() {
        return FileStore.safeArrayToList(this.sessionsDir.list());
    }

    public File getReport(String sessionId) {
        return new File(this.reportsDir, sessionId);
    }

    public List<File> getReports() {
        return FileStore.safeArrayToList(this.reportsDir.listFiles());
    }

    public File getPriorityReport(String sessionId) {
        return new File(this.priorityReportsDir, sessionId);
    }

    public List<File> getPriorityReports() {
        return FileStore.safeArrayToList(this.priorityReportsDir.listFiles());
    }

    public File getNativeReport(String sessionId) {
        return new File(this.nativeReportsDir, sessionId);
    }

    public List<File> getNativeReports() {
        return FileStore.safeArrayToList(this.nativeReportsDir.listFiles());
    }

    private static File prepareDir(File file) {
        file.mkdirs();
        return file;
    }

    private static synchronized File prepareBaseDir(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return file;
            }
            Logger.getLogger().d("Unexpected non-directory file: " + file + "; deleting file and creating new directory.");
            file.delete();
        }
        if (!file.mkdirs()) {
            Logger.getLogger().e("Could not create Crashlytics-specific directory: " + file);
        }
        return file;
    }

    private static <T> List<T> safeArrayToList(@Nullable T[] array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    private boolean useV3FileSystem() {
        return !this.processName.isEmpty();
    }

    @VisibleForTesting
    static String sanitizeName(String filename) {
        if (filename.length() > 40) {
            return CommonUtils.sha1(filename);
        }
        return filename.replaceAll("[^a-zA-Z0-9.]", "_");
    }
}

