/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.google.firebase.crashlytics.internal.Logger;

class BatteryState {
    static final int VELOCITY_UNPLUGGED = 1;
    static final int VELOCITY_CHARGING = 2;
    static final int VELOCITY_FULL = 3;
    private final Float level;
    private final boolean powerConnected;

    private BatteryState(Float level, boolean powerConnected) {
        this.powerConnected = powerConnected;
        this.level = level;
    }

    boolean isPowerConnected() {
        return this.powerConnected;
    }

    public Float getBatteryLevel() {
        return this.level;
    }

    public int getBatteryVelocity() {
        if (!this.powerConnected || this.level == null) {
            return 1;
        }
        if ((double)this.level.floatValue() < 0.99) {
            return 2;
        }
        return 3;
    }

    public static BatteryState get(Context context) {
        boolean powerConnected = false;
        Float level = null;
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatusIntent = context.registerReceiver(null, ifilter);
            if (batteryStatusIntent != null) {
                powerConnected = BatteryState.isPowerConnected(batteryStatusIntent);
                level = BatteryState.getLevel(batteryStatusIntent);
            }
        }
        catch (IllegalStateException ex) {
            Logger.getLogger().e("An error occurred getting battery state.", ex);
        }
        return new BatteryState(level, powerConnected);
    }

    private static boolean isPowerConnected(Intent batteryStatusIntent) {
        int status = batteryStatusIntent.getIntExtra("status", -1);
        if (status == -1) {
            return false;
        }
        return status == 2 || status == 5;
    }

    private static Float getLevel(Intent batteryStatusIntent) {
        int level = batteryStatusIntent.getIntExtra("level", -1);
        int scale = batteryStatusIntent.getIntExtra("scale", -1);
        if (level == -1 || scale == -1) {
            return null;
        }
        return Float.valueOf((float)level / (float)scale);
    }
}

