/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;

final class AutoValue_CrashlyticsReport_Session_Device
extends CrashlyticsReport.Session.Device {
    private final int arch;
    private final String model;
    private final int cores;
    private final long ram;
    private final long diskSpace;
    private final boolean simulator;
    private final int state;
    private final String manufacturer;
    private final String modelClass;

    private AutoValue_CrashlyticsReport_Session_Device(int arch, String model, int cores, long ram, long diskSpace, boolean simulator, int state, String manufacturer, String modelClass) {
        this.arch = arch;
        this.model = model;
        this.cores = cores;
        this.ram = ram;
        this.diskSpace = diskSpace;
        this.simulator = simulator;
        this.state = state;
        this.manufacturer = manufacturer;
        this.modelClass = modelClass;
    }

    @Override
    @NonNull
    public int getArch() {
        return this.arch;
    }

    @Override
    @NonNull
    public String getModel() {
        return this.model;
    }

    @Override
    public int getCores() {
        return this.cores;
    }

    @Override
    public long getRam() {
        return this.ram;
    }

    @Override
    public long getDiskSpace() {
        return this.diskSpace;
    }

    @Override
    public boolean isSimulator() {
        return this.simulator;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    @NonNull
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    @NonNull
    public String getModelClass() {
        return this.modelClass;
    }

    public String toString() {
        return "Device{arch=" + this.arch + ", model=" + this.model + ", cores=" + this.cores + ", ram=" + this.ram + ", diskSpace=" + this.diskSpace + ", simulator=" + this.simulator + ", state=" + this.state + ", manufacturer=" + this.manufacturer + ", modelClass=" + this.modelClass + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CrashlyticsReport.Session.Device) {
            CrashlyticsReport.Session.Device that = (CrashlyticsReport.Session.Device)o;
            return this.arch == that.getArch() && this.model.equals(that.getModel()) && this.cores == that.getCores() && this.ram == that.getRam() && this.diskSpace == that.getDiskSpace() && this.simulator == that.isSimulator() && this.state == that.getState() && this.manufacturer.equals(that.getManufacturer()) && this.modelClass.equals(that.getModelClass());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.arch;
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.cores;
        h$ *= 1000003;
        h$ ^= (int)(this.ram >>> 32 ^ this.ram);
        h$ *= 1000003;
        h$ ^= (int)(this.diskSpace >>> 32 ^ this.diskSpace);
        h$ *= 1000003;
        h$ ^= this.simulator ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.state;
        h$ *= 1000003;
        h$ ^= this.manufacturer.hashCode();
        h$ *= 1000003;
        return h$ ^= this.modelClass.hashCode();
    }

    static final class Builder
    extends CrashlyticsReport.Session.Device.Builder {
        private int arch;
        private String model;
        private int cores;
        private long ram;
        private long diskSpace;
        private boolean simulator;
        private int state;
        private String manufacturer;
        private String modelClass;
        private byte set$0;

        Builder() {
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setArch(int arch) {
            this.arch = arch;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setModel(String model) {
            if (model == null) {
                throw new NullPointerException("Null model");
            }
            this.model = model;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setCores(int cores) {
            this.cores = cores;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setRam(long ram) {
            this.ram = ram;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setDiskSpace(long diskSpace) {
            this.diskSpace = diskSpace;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setSimulator(boolean simulator) {
            this.simulator = simulator;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setState(int state) {
            this.state = state;
            this.set$0 = (byte)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setManufacturer(String manufacturer) {
            if (manufacturer == null) {
                throw new NullPointerException("Null manufacturer");
            }
            this.manufacturer = manufacturer;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device.Builder setModelClass(String modelClass) {
            if (modelClass == null) {
                throw new NullPointerException("Null modelClass");
            }
            this.modelClass = modelClass;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Device build() {
            if (this.set$0 != 63 || this.model == null || this.manufacturer == null || this.modelClass == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" arch");
                }
                if (this.model == null) {
                    missing.append(" model");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" cores");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" ram");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" diskSpace");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" simulator");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" state");
                }
                if (this.manufacturer == null) {
                    missing.append(" manufacturer");
                }
                if (this.modelClass == null) {
                    missing.append(" modelClass");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CrashlyticsReport_Session_Device(this.arch, this.model, this.cores, this.ram, this.diskSpace, this.simulator, this.state, this.manufacturer, this.modelClass);
        }
    }
}

