/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.auto.value.AutoValue;
import com.google.firebase.crashlytics.internal.metadata.AutoRolloutAssignmentEncoder;
import com.google.firebase.crashlytics.internal.metadata.AutoValue_RolloutAssignment;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.annotations.Encodable;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import org.json.JSONException;
import org.json.JSONObject;

@Encodable
@AutoValue
public abstract class RolloutAssignment {
    private static final int MAX_PARAMETER_VALUE_LENGTH = 256;
    public static final DataEncoder ROLLOUT_ASSIGNMENT_JSON_ENCODER = new JsonDataEncoderBuilder().configureWith(AutoRolloutAssignmentEncoder.CONFIG).build();

    public abstract String getRolloutId();

    public abstract String getParameterKey();

    public abstract String getParameterValue();

    public abstract String getVariantId();

    public abstract long getTemplateVersion();

    public static RolloutAssignment create(String rolloutId, String parameterKey, String parameterValue, String variantId, long templateVersion) {
        String validatedParameterValue = RolloutAssignment.validate(parameterValue);
        return new AutoValue_RolloutAssignment(rolloutId, parameterKey, validatedParameterValue, variantId, templateVersion);
    }

    static RolloutAssignment create(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        String rolloutId = dataObj.getString("rolloutId");
        String parameterKey = dataObj.getString("parameterKey");
        String parameterValue = dataObj.getString("parameterValue");
        String variantId = dataObj.getString("variantId");
        long templateVersion = dataObj.getLong("templateVersion");
        return RolloutAssignment.create(rolloutId, parameterKey, parameterValue, variantId, templateVersion);
    }

    public CrashlyticsReport.Session.Event.RolloutAssignment toReportProto() {
        return CrashlyticsReport.Session.Event.RolloutAssignment.builder().setRolloutVariant(CrashlyticsReport.Session.Event.RolloutAssignment.RolloutVariant.builder().setVariantId(this.getVariantId()).setRolloutId(this.getRolloutId()).build()).setParameterKey(this.getParameterKey()).setParameterValue(this.getParameterValue()).setTemplateVersion(this.getTemplateVersion()).build();
    }

    private static String validate(String parameterValue) {
        String validatedParameterValue = parameterValue;
        if (validatedParameterValue.length() > 256) {
            validatedParameterValue = validatedParameterValue.substring(0, 256);
        }
        return validatedParameterValue;
    }
}

