/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_ApplicationExitInfo;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_ApplicationExitInfo_BuildIdMappingForArch;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_CustomAttribute;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_FilesPayload;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_FilesPayload_File;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Application;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Application_Organization;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Device;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_BinaryImage;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Exception;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Signal;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread_Frame;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_ProcessDetails;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Device;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Log;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_RolloutAssignment;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_RolloutAssignment_RolloutVariant;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_RolloutsState;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_OperatingSystem;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_User;
import com.google.firebase.encoders.annotations.Encodable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.Charset;
import java.util.List;

@Encodable
@AutoValue
public abstract class CrashlyticsReport {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @NonNull
    public static Builder builder() {
        return new AutoValue_CrashlyticsReport.Builder();
    }

    @Encodable.Ignore
    public Type getType() {
        if (this.getSession() != null) {
            return Type.JAVA;
        }
        if (this.getNdkPayload() != null) {
            return Type.NATIVE;
        }
        return Type.INCOMPLETE;
    }

    @NonNull
    public abstract String getSdkVersion();

    @NonNull
    public abstract String getGmpAppId();

    public abstract int getPlatform();

    @NonNull
    public abstract String getInstallationUuid();

    @Nullable
    public abstract String getFirebaseInstallationId();

    @Nullable
    public abstract String getAppQualitySessionId();

    @NonNull
    public abstract String getBuildVersion();

    @NonNull
    public abstract String getDisplayVersion();

    @Nullable
    public abstract Session getSession();

    @Nullable
    public abstract FilesPayload getNdkPayload();

    @Nullable
    public abstract ApplicationExitInfo getAppExitInfo();

    @NonNull
    protected abstract Builder toBuilder();

    @NonNull
    public CrashlyticsReport withEvents(@NonNull List<Session.Event> events) {
        if (this.getSession() == null) {
            throw new IllegalStateException("Reports without sessions cannot have events added to them.");
        }
        return this.toBuilder().setSession(this.getSession().withEvents(events)).build();
    }

    @NonNull
    public CrashlyticsReport withOrganizationId(@NonNull String organizationId) {
        Session session;
        Builder builder = this.toBuilder();
        FilesPayload ndkPayload = this.getNdkPayload();
        if (ndkPayload != null) {
            builder.setNdkPayload(ndkPayload.toBuilder().setOrgId(organizationId).build());
        }
        if ((session = this.getSession()) != null) {
            builder.setSession(session.withOrganizationId(organizationId));
        }
        return builder.build();
    }

    @NonNull
    public CrashlyticsReport withNdkPayload(@NonNull FilesPayload filesPayload) {
        return this.toBuilder().setSession(null).setNdkPayload(filesPayload).build();
    }

    @NonNull
    public CrashlyticsReport withApplicationExitInfo(ApplicationExitInfo appExitInfo) {
        return appExitInfo == null ? this : this.toBuilder().setAppExitInfo(appExitInfo).build();
    }

    @NonNull
    public CrashlyticsReport withSessionEndFields(long endedAt, boolean isCrashed, @Nullable String userId) {
        Builder builder = this.toBuilder();
        if (this.getSession() != null) {
            builder.setSession(this.getSession().withSessionEndFields(endedAt, isCrashed, userId));
        }
        return builder.build();
    }

    @NonNull
    public CrashlyticsReport withAppQualitySessionId(@Nullable String appQualitySessionId) {
        Builder builder = this.toBuilder().setAppQualitySessionId(appQualitySessionId);
        if (this.getSession() != null) {
            builder.setSession(this.getSession().withAppQualitySessionId(appQualitySessionId));
        }
        return builder.build();
    }

    @NonNull
    public CrashlyticsReport withFirebaseInstallationId(@Nullable String firebaseInstallationId) {
        return this.toBuilder().setFirebaseInstallationId(firebaseInstallationId).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @NonNull
        public abstract Builder setSdkVersion(@NonNull String var1);

        @NonNull
        public abstract Builder setGmpAppId(@NonNull String var1);

        @NonNull
        public abstract Builder setPlatform(int var1);

        @NonNull
        public abstract Builder setInstallationUuid(@NonNull String var1);

        @NonNull
        public abstract Builder setAppQualitySessionId(@Nullable String var1);

        @NonNull
        public abstract Builder setFirebaseInstallationId(@Nullable String var1);

        @NonNull
        public abstract Builder setBuildVersion(@NonNull String var1);

        @NonNull
        public abstract Builder setDisplayVersion(@NonNull String var1);

        @NonNull
        public abstract Builder setSession(@NonNull Session var1);

        @NonNull
        public abstract Builder setNdkPayload(FilesPayload var1);

        @NonNull
        public abstract Builder setAppExitInfo(ApplicationExitInfo var1);

        @NonNull
        public abstract CrashlyticsReport build();
    }

    @AutoValue
    public static abstract class ApplicationExitInfo {
        @NonNull
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_ApplicationExitInfo.Builder();
        }

        @NonNull
        public abstract int getPid();

        @NonNull
        public abstract String getProcessName();

        @NonNull
        public abstract int getReasonCode();

        @NonNull
        public abstract int getImportance();

        @NonNull
        public abstract long getPss();

        @NonNull
        public abstract long getRss();

        @NonNull
        public abstract long getTimestamp();

        @Nullable
        public abstract String getTraceFile();

        @Nullable
        public abstract List<BuildIdMappingForArch> getBuildIdMappingForArch();

        @AutoValue
        public static abstract class BuildIdMappingForArch {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_ApplicationExitInfo_BuildIdMappingForArch.Builder();
            }

            @NonNull
            public abstract String getArch();

            @NonNull
            public abstract String getLibraryName();

            @NonNull
            public abstract String getBuildId();

            @AutoValue.Builder
            public static abstract class Builder {
                @NonNull
                public abstract Builder setArch(@NonNull String var1);

                @NonNull
                public abstract Builder setLibraryName(@NonNull String var1);

                @NonNull
                public abstract Builder setBuildId(@NonNull String var1);

                @NonNull
                public abstract BuildIdMappingForArch build();
            }
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @NonNull
            public abstract Builder setPid(@NonNull int var1);

            @NonNull
            public abstract Builder setProcessName(@NonNull String var1);

            @NonNull
            public abstract Builder setReasonCode(@NonNull int var1);

            @NonNull
            public abstract Builder setImportance(@NonNull int var1);

            @NonNull
            public abstract Builder setPss(@NonNull long var1);

            @NonNull
            public abstract Builder setRss(@NonNull long var1);

            @NonNull
            public abstract Builder setTimestamp(@NonNull long var1);

            @NonNull
            public abstract Builder setTraceFile(@Nullable String var1);

            @NonNull
            public abstract Builder setBuildIdMappingForArch(@Nullable List<BuildIdMappingForArch> var1);

            @NonNull
            public abstract ApplicationExitInfo build();
        }
    }

    @AutoValue
    public static abstract class Session {
        @NonNull
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_Session.Builder().setCrashed(false);
        }

        @NonNull
        public abstract String getGenerator();

        @Encodable.Ignore
        @NonNull
        public abstract String getIdentifier();

        @Encodable.Field(name="identifier")
        @NonNull
        public byte[] getIdentifierUtf8Bytes() {
            return this.getIdentifier().getBytes(UTF_8);
        }

        @Nullable
        public abstract String getAppQualitySessionId();

        public abstract long getStartedAt();

        @Nullable
        public abstract Long getEndedAt();

        public abstract boolean isCrashed();

        @NonNull
        public abstract Application getApp();

        @Nullable
        public abstract User getUser();

        @Nullable
        public abstract OperatingSystem getOs();

        @Nullable
        public abstract Device getDevice();

        @Nullable
        public abstract List<Event> getEvents();

        public abstract int getGeneratorType();

        @NonNull
        public abstract Builder toBuilder();

        @NonNull
        Session withEvents(@NonNull List<Event> events) {
            return this.toBuilder().setEvents(events).build();
        }

        @NonNull
        Session withOrganizationId(@NonNull String organizationId) {
            Application app = this.getApp().withOrganizationId(organizationId);
            return this.toBuilder().setApp(app).build();
        }

        @NonNull
        Session withSessionEndFields(long timestamp, boolean isCrashed, @Nullable String userId) {
            Builder builder = this.toBuilder();
            builder.setEndedAt(timestamp);
            builder.setCrashed(isCrashed);
            if (userId != null) {
                builder.setUser(User.builder().setIdentifier(userId).build());
            }
            return builder.build();
        }

        @NonNull
        Session withAppQualitySessionId(@Nullable String appQualitySessionId) {
            return this.toBuilder().setAppQualitySessionId(appQualitySessionId).build();
        }

        @AutoValue
        public static abstract class Event {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_Event.Builder();
            }

            public abstract long getTimestamp();

            @NonNull
            public abstract String getType();

            @NonNull
            public abstract Application getApp();

            @NonNull
            public abstract Device getDevice();

            @Nullable
            public abstract Log getLog();

            @Nullable
            public abstract RolloutsState getRollouts();

            @NonNull
            public abstract Builder toBuilder();

            @AutoValue.Builder
            public static abstract class Builder {
                @NonNull
                public abstract Builder setTimestamp(long var1);

                @NonNull
                public abstract Builder setType(@NonNull String var1);

                @NonNull
                public abstract Builder setApp(@NonNull Application var1);

                @NonNull
                public abstract Builder setDevice(@NonNull Device var1);

                @NonNull
                public abstract Builder setLog(@NonNull Log var1);

                @NonNull
                public abstract Builder setRollouts(@NonNull RolloutsState var1);

                @NonNull
                public abstract Event build();
            }

            @AutoValue
            public static abstract class RolloutAssignment {
                @NonNull
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_RolloutAssignment.Builder();
                }

                @NonNull
                public abstract RolloutVariant getRolloutVariant();

                @NonNull
                public abstract String getParameterKey();

                @NonNull
                public abstract String getParameterValue();

                @NonNull
                public abstract long getTemplateVersion();

                @AutoValue
                public static abstract class RolloutVariant {
                    public static Builder builder() {
                        return new AutoValue_CrashlyticsReport_Session_Event_RolloutAssignment_RolloutVariant.Builder();
                    }

                    @NonNull
                    public abstract String getRolloutId();

                    @NonNull
                    public abstract String getVariantId();

                    @AutoValue.Builder
                    public static abstract class Builder {
                        @NonNull
                        public abstract Builder setRolloutId(@NonNull String var1);

                        @NonNull
                        public abstract Builder setVariantId(@NonNull String var1);

                        @NonNull
                        public abstract RolloutVariant build();
                    }
                }

                @AutoValue.Builder
                public static abstract class Builder {
                    @NonNull
                    public abstract Builder setRolloutVariant(@NonNull RolloutVariant var1);

                    @NonNull
                    public abstract Builder setParameterKey(@NonNull String var1);

                    @NonNull
                    public abstract Builder setParameterValue(@NonNull String var1);

                    @NonNull
                    public abstract Builder setTemplateVersion(@NonNull long var1);

                    @NonNull
                    public abstract RolloutAssignment build();
                }
            }

            @AutoValue
            public static abstract class RolloutsState {
                @NonNull
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_RolloutsState.Builder();
                }

                @Encodable.Field(name="assignments")
                @NonNull
                public abstract List<RolloutAssignment> getRolloutAssignments();

                @AutoValue.Builder
                public static abstract class Builder {
                    @NonNull
                    public abstract Builder setRolloutAssignments(@NonNull List<RolloutAssignment> var1);

                    @NonNull
                    public abstract RolloutsState build();
                }
            }

            @AutoValue
            public static abstract class Log {
                @NonNull
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_Log.Builder();
                }

                @NonNull
                public abstract String getContent();

                @AutoValue.Builder
                public static abstract class Builder {
                    @NonNull
                    public abstract Builder setContent(@NonNull String var1);

                    @NonNull
                    public abstract Log build();
                }
            }

            @AutoValue
            public static abstract class Device {
                @NonNull
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_Device.Builder();
                }

                @Nullable
                public abstract Double getBatteryLevel();

                public abstract int getBatteryVelocity();

                public abstract boolean isProximityOn();

                public abstract int getOrientation();

                public abstract long getRamUsed();

                public abstract long getDiskUsed();

                @AutoValue.Builder
                public static abstract class Builder {
                    @NonNull
                    public abstract Builder setBatteryLevel(Double var1);

                    @NonNull
                    public abstract Builder setBatteryVelocity(int var1);

                    @NonNull
                    public abstract Builder setProximityOn(boolean var1);

                    @NonNull
                    public abstract Builder setOrientation(int var1);

                    @NonNull
                    public abstract Builder setRamUsed(long var1);

                    @NonNull
                    public abstract Builder setDiskUsed(long var1);

                    @NonNull
                    public abstract Device build();
                }
            }

            @AutoValue
            public static abstract class Application {
                @NonNull
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_Application.Builder();
                }

                @NonNull
                public abstract Execution getExecution();

                @Nullable
                public abstract List<CustomAttribute> getCustomAttributes();

                @Nullable
                public abstract List<CustomAttribute> getInternalKeys();

                @Nullable
                public abstract Boolean getBackground();

                @Nullable
                public abstract ProcessDetails getCurrentProcessDetails();

                @Nullable
                public abstract List<ProcessDetails> getAppProcessDetails();

                public abstract int getUiOrientation();

                @NonNull
                public abstract Builder toBuilder();

                @AutoValue.Builder
                public static abstract class Builder {
                    @NonNull
                    public abstract Builder setExecution(@NonNull Execution var1);

                    @NonNull
                    public abstract Builder setCustomAttributes(@NonNull List<CustomAttribute> var1);

                    @NonNull
                    public abstract Builder setInternalKeys(@NonNull List<CustomAttribute> var1);

                    @NonNull
                    public abstract Builder setBackground(@Nullable Boolean var1);

                    @NonNull
                    public abstract Builder setCurrentProcessDetails(@Nullable ProcessDetails var1);

                    @NonNull
                    public abstract Builder setAppProcessDetails(@Nullable List<ProcessDetails> var1);

                    @NonNull
                    public abstract Builder setUiOrientation(int var1);

                    @NonNull
                    public abstract Application build();
                }

                @AutoValue
                public static abstract class ProcessDetails {
                    @NonNull
                    public abstract String getProcessName();

                    public abstract int getPid();

                    public abstract int getImportance();

                    public abstract boolean isDefaultProcess();

                    @NonNull
                    public static Builder builder() {
                        return new AutoValue_CrashlyticsReport_Session_Event_Application_ProcessDetails.Builder();
                    }

                    @AutoValue.Builder
                    public static abstract class Builder {
                        @NonNull
                        public abstract Builder setProcessName(@NonNull String var1);

                        @NonNull
                        public abstract Builder setPid(int var1);

                        @NonNull
                        public abstract Builder setImportance(int var1);

                        @NonNull
                        public abstract Builder setDefaultProcess(boolean var1);

                        @NonNull
                        public abstract ProcessDetails build();
                    }
                }

                @AutoValue
                public static abstract class Execution {
                    @NonNull
                    public static Builder builder() {
                        return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution.Builder();
                    }

                    @Nullable
                    public abstract List<Thread> getThreads();

                    @Nullable
                    public abstract Exception getException();

                    @Nullable
                    public abstract ApplicationExitInfo getAppExitInfo();

                    @NonNull
                    public abstract Signal getSignal();

                    @NonNull
                    public abstract List<BinaryImage> getBinaries();

                    @AutoValue.Builder
                    public static abstract class Builder {
                        @NonNull
                        public abstract Builder setThreads(@NonNull List<Thread> var1);

                        @NonNull
                        public abstract Builder setException(@NonNull Exception var1);

                        @NonNull
                        public abstract Builder setAppExitInfo(@NonNull ApplicationExitInfo var1);

                        @NonNull
                        public abstract Builder setSignal(@NonNull Signal var1);

                        @NonNull
                        public abstract Builder setBinaries(@NonNull List<BinaryImage> var1);

                        @NonNull
                        public abstract Execution build();
                    }

                    @AutoValue
                    public static abstract class BinaryImage {
                        @NonNull
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_BinaryImage.Builder();
                        }

                        @NonNull
                        public abstract long getBaseAddress();

                        public abstract long getSize();

                        @NonNull
                        public abstract String getName();

                        @Encodable.Ignore
                        @Nullable
                        public abstract String getUuid();

                        @Encodable.Field(name="uuid")
                        @Nullable
                        public byte[] getUuidUtf8Bytes() {
                            String uuid = this.getUuid();
                            return uuid != null ? uuid.getBytes(UTF_8) : null;
                        }

                        @AutoValue.Builder
                        public static abstract class Builder {
                            @NonNull
                            public abstract Builder setBaseAddress(long var1);

                            @NonNull
                            public abstract Builder setSize(long var1);

                            @NonNull
                            public abstract Builder setName(@NonNull String var1);

                            @NonNull
                            public abstract Builder setUuid(@Nullable String var1);

                            @NonNull
                            public Builder setUuidFromUtf8Bytes(@NonNull byte[] utf8Bytes) {
                                return this.setUuid(new String(utf8Bytes, UTF_8));
                            }

                            @NonNull
                            public abstract BinaryImage build();
                        }
                    }

                    @AutoValue
                    public static abstract class Signal {
                        @NonNull
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Signal.Builder();
                        }

                        @NonNull
                        public abstract String getName();

                        @NonNull
                        public abstract String getCode();

                        @NonNull
                        public abstract long getAddress();

                        @AutoValue.Builder
                        public static abstract class Builder {
                            @NonNull
                            public abstract Builder setName(@NonNull String var1);

                            @NonNull
                            public abstract Builder setCode(@NonNull String var1);

                            @NonNull
                            public abstract Builder setAddress(long var1);

                            @NonNull
                            public abstract Signal build();
                        }
                    }

                    @AutoValue
                    public static abstract class Exception {
                        @NonNull
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Exception.Builder();
                        }

                        @NonNull
                        public abstract String getType();

                        @Nullable
                        public abstract String getReason();

                        @NonNull
                        public abstract List<Thread.Frame> getFrames();

                        @Nullable
                        public abstract Exception getCausedBy();

                        public abstract int getOverflowCount();

                        @AutoValue.Builder
                        public static abstract class Builder {
                            @NonNull
                            public abstract Builder setType(@NonNull String var1);

                            @NonNull
                            public abstract Builder setReason(@NonNull String var1);

                            @NonNull
                            public abstract Builder setFrames(@NonNull List<Thread.Frame> var1);

                            @NonNull
                            public abstract Builder setCausedBy(@NonNull Exception var1);

                            @NonNull
                            public abstract Builder setOverflowCount(int var1);

                            @NonNull
                            public abstract Exception build();
                        }
                    }

                    @AutoValue
                    public static abstract class Thread {
                        @NonNull
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread.Builder();
                        }

                        @NonNull
                        public abstract String getName();

                        public abstract int getImportance();

                        @NonNull
                        public abstract List<Frame> getFrames();

                        @AutoValue.Builder
                        public static abstract class Builder {
                            @NonNull
                            public abstract Builder setName(@NonNull String var1);

                            @NonNull
                            public abstract Builder setImportance(int var1);

                            @NonNull
                            public abstract Builder setFrames(@NonNull List<Frame> var1);

                            @NonNull
                            public abstract Thread build();
                        }

                        @AutoValue
                        public static abstract class Frame {
                            @NonNull
                            public static Builder builder() {
                                return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread_Frame.Builder();
                            }

                            public abstract long getPc();

                            @NonNull
                            public abstract String getSymbol();

                            @Nullable
                            public abstract String getFile();

                            public abstract long getOffset();

                            public abstract int getImportance();

                            @AutoValue.Builder
                            public static abstract class Builder {
                                @NonNull
                                public abstract Builder setPc(long var1);

                                @NonNull
                                public abstract Builder setSymbol(@NonNull String var1);

                                @NonNull
                                public abstract Builder setFile(@NonNull String var1);

                                @NonNull
                                public abstract Builder setOffset(long var1);

                                @NonNull
                                public abstract Builder setImportance(int var1);

                                @NonNull
                                public abstract Frame build();
                            }
                        }
                    }
                }
            }
        }

        @AutoValue
        public static abstract class Device {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_Device.Builder();
            }

            @NonNull
            public abstract int getArch();

            @NonNull
            public abstract String getModel();

            public abstract int getCores();

            public abstract long getRam();

            public abstract long getDiskSpace();

            public abstract boolean isSimulator();

            public abstract int getState();

            @NonNull
            public abstract String getManufacturer();

            @NonNull
            public abstract String getModelClass();

            @AutoValue.Builder
            public static abstract class Builder {
                @NonNull
                public abstract Builder setArch(int var1);

                @NonNull
                public abstract Builder setModel(@NonNull String var1);

                @NonNull
                public abstract Builder setCores(int var1);

                @NonNull
                public abstract Builder setRam(long var1);

                @NonNull
                public abstract Builder setDiskSpace(long var1);

                @NonNull
                public abstract Builder setSimulator(boolean var1);

                @NonNull
                public abstract Builder setState(int var1);

                @NonNull
                public abstract Builder setManufacturer(@NonNull String var1);

                @NonNull
                public abstract Builder setModelClass(@NonNull String var1);

                @NonNull
                public abstract Device build();
            }
        }

        @AutoValue
        public static abstract class OperatingSystem {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_OperatingSystem.Builder();
            }

            public abstract int getPlatform();

            @NonNull
            public abstract String getVersion();

            @NonNull
            public abstract String getBuildVersion();

            public abstract boolean isJailbroken();

            @AutoValue.Builder
            public static abstract class Builder {
                @NonNull
                public abstract Builder setPlatform(int var1);

                @NonNull
                public abstract Builder setVersion(@NonNull String var1);

                @NonNull
                public abstract Builder setBuildVersion(@NonNull String var1);

                @NonNull
                public abstract Builder setJailbroken(boolean var1);

                @NonNull
                public abstract OperatingSystem build();
            }
        }

        @AutoValue
        public static abstract class Application {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_Application.Builder();
            }

            @NonNull
            public abstract String getIdentifier();

            @NonNull
            public abstract String getVersion();

            @Nullable
            public abstract String getDisplayVersion();

            @Nullable
            public abstract Organization getOrganization();

            @Nullable
            public abstract String getInstallationUuid();

            @Nullable
            public abstract String getDevelopmentPlatform();

            @Nullable
            public abstract String getDevelopmentPlatformVersion();

            @NonNull
            protected abstract Builder toBuilder();

            @NonNull
            Application withOrganizationId(@NonNull String organizationId) {
                Organization organization = this.getOrganization();
                Organization.Builder builder = organization != null ? organization.toBuilder() : Organization.builder();
                return this.toBuilder().setOrganization(builder.setClsId(organizationId).build()).build();
            }

            @AutoValue
            public static abstract class Organization {
                @NonNull
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Application_Organization.Builder();
                }

                @NonNull
                public abstract String getClsId();

                @NonNull
                protected abstract Builder toBuilder();

                @AutoValue.Builder
                public static abstract class Builder {
                    @NonNull
                    public abstract Builder setClsId(@NonNull String var1);

                    @NonNull
                    public abstract Organization build();
                }
            }

            @AutoValue.Builder
            public static abstract class Builder {
                @NonNull
                public abstract Builder setIdentifier(@NonNull String var1);

                @NonNull
                public abstract Builder setVersion(@NonNull String var1);

                @NonNull
                public abstract Builder setDisplayVersion(@NonNull String var1);

                @NonNull
                public abstract Builder setOrganization(@NonNull Organization var1);

                @NonNull
                public abstract Builder setInstallationUuid(@NonNull String var1);

                @NonNull
                public abstract Builder setDevelopmentPlatform(@Nullable String var1);

                @NonNull
                public abstract Builder setDevelopmentPlatformVersion(@Nullable String var1);

                @NonNull
                public abstract Application build();
            }
        }

        @AutoValue
        public static abstract class User {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_User.Builder();
            }

            @NonNull
            public abstract String getIdentifier();

            @AutoValue.Builder
            public static abstract class Builder {
                @NonNull
                public abstract Builder setIdentifier(@NonNull String var1);

                @NonNull
                public abstract User build();
            }
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @NonNull
            public abstract Builder setGenerator(@NonNull String var1);

            @NonNull
            public abstract Builder setIdentifier(@NonNull String var1);

            @NonNull
            public Builder setIdentifierFromUtf8Bytes(@NonNull byte[] utf8Bytes) {
                return this.setIdentifier(new String(utf8Bytes, UTF_8));
            }

            @NonNull
            public abstract Builder setAppQualitySessionId(@Nullable String var1);

            @NonNull
            public abstract Builder setStartedAt(long var1);

            @NonNull
            public abstract Builder setEndedAt(@NonNull Long var1);

            @NonNull
            public abstract Builder setCrashed(boolean var1);

            @NonNull
            public abstract Builder setUser(@NonNull User var1);

            @NonNull
            public abstract Builder setApp(@NonNull Application var1);

            @NonNull
            public abstract Builder setOs(@NonNull OperatingSystem var1);

            @NonNull
            public abstract Builder setDevice(@NonNull Device var1);

            @NonNull
            public abstract Builder setEvents(@NonNull List<Event> var1);

            @NonNull
            public abstract Builder setGeneratorType(int var1);

            @NonNull
            public abstract Session build();
        }
    }

    @AutoValue
    public static abstract class CustomAttribute {
        @NonNull
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_CustomAttribute.Builder();
        }

        @NonNull
        public abstract String getKey();

        @NonNull
        public abstract String getValue();

        @AutoValue.Builder
        public static abstract class Builder {
            @NonNull
            public abstract Builder setKey(@NonNull String var1);

            @NonNull
            public abstract Builder setValue(@NonNull String var1);

            @NonNull
            public abstract CustomAttribute build();
        }
    }

    @AutoValue
    public static abstract class FilesPayload {
        @NonNull
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_FilesPayload.Builder();
        }

        @NonNull
        public abstract List<File> getFiles();

        @Nullable
        public abstract String getOrgId();

        abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setFiles(List<File> var1);

            public abstract Builder setOrgId(String var1);

            public abstract FilesPayload build();
        }

        @AutoValue
        public static abstract class File {
            @NonNull
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_FilesPayload_File.Builder();
            }

            @NonNull
            public abstract String getFilename();

            @NonNull
            public abstract byte[] getContents();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setFilename(String var1);

                public abstract Builder setContents(byte[] var1);

                public abstract File build();
            }
        }
    }

    public static enum Type {
        INCOMPLETE,
        JAVA,
        NATIVE;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Architecture {
        public static final int ARMV6 = 5;
        public static final int ARMV7 = 6;
        public static final int ARM64 = 9;
        public static final int X86_32 = 0;
        public static final int X86_64 = 1;
        public static final int UNKNOWN = 7;
    }
}

