/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

class CrashlyticsAppQualitySessionsStore {
    private static final String AQS_SESSION_ID_FILENAME_PREFIX = "aqs.";
    private static final FilenameFilter AQS_SESSION_ID_FILE_FILTER = (dir, name) -> name.startsWith(AQS_SESSION_ID_FILENAME_PREFIX);
    private static final Comparator<File> FILE_RECENCY_COMPARATOR = (file1, file2) -> Long.compare(file2.lastModified(), file1.lastModified());
    private final FileStore fileStore;
    @Nullable
    private String sessionId = null;
    @Nullable
    private String appQualitySessionId = null;

    CrashlyticsAppQualitySessionsStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    @Nullable
    public synchronized String getAppQualitySessionId(@NonNull String sessionId) {
        if (Objects.equals(this.sessionId, sessionId)) {
            return this.appQualitySessionId;
        }
        return CrashlyticsAppQualitySessionsStore.readAqsSessionIdFile(this.fileStore, sessionId);
    }

    public synchronized void rotateAppQualitySessionId(@NonNull String newAppQualitySessionId) {
        if (!Objects.equals(this.appQualitySessionId, newAppQualitySessionId)) {
            CrashlyticsAppQualitySessionsStore.persist(this.fileStore, this.sessionId, newAppQualitySessionId);
            this.appQualitySessionId = newAppQualitySessionId;
        }
    }

    public synchronized void rotateSessionId(@Nullable String newSessionId) {
        if (!Objects.equals(this.sessionId, newSessionId)) {
            CrashlyticsAppQualitySessionsStore.persist(this.fileStore, newSessionId, this.appQualitySessionId);
            this.sessionId = newSessionId;
        }
    }

    private static void persist(FileStore fileStore, @Nullable String sessionId, @Nullable String appQualitySessionId) {
        if (sessionId != null && appQualitySessionId != null) {
            try {
                fileStore.getSessionFile(sessionId, AQS_SESSION_ID_FILENAME_PREFIX + appQualitySessionId).createNewFile();
            }
            catch (IOException ex) {
                Logger.getLogger().w("Failed to persist App Quality Sessions session id.", ex);
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String readAqsSessionIdFile(FileStore fileStore, @NonNull String sessionId) {
        List<File> aqsFiles = fileStore.getSessionFiles(sessionId, AQS_SESSION_ID_FILE_FILTER);
        if (aqsFiles.isEmpty()) {
            Logger.getLogger().w("Unable to read App Quality Sessions session id.");
            return null;
        }
        File mostRecentAqsFile = Collections.min(aqsFiles, FILE_RECENCY_COMPARATOR);
        return mostRecentAqsFile.getName().substring(AQS_SESSION_ID_FILENAME_PREFIX.length());
    }
}

