/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.InstallIdProvider;
import com.google.firebase.crashlytics.internal.common.InstallerPackageNameProvider;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;

public class IdManager
implements InstallIdProvider {
    public static final String DEFAULT_VERSION_NAME = "0.0";
    static final String PREFKEY_ADVERTISING_ID = "crashlytics.advertising.id";
    static final String PREFKEY_INSTALLATION_UUID = "crashlytics.installation.id";
    static final String PREFKEY_FIREBASE_IID = "firebase.installation.id";
    static final String PREFKEY_LEGACY_INSTALLATION_UUID = "crashlytics.installation.id";
    private static final Pattern ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
    private static final String SYNTHETIC_FID_PREFIX = "SYN_";
    private static final String FORWARD_SLASH_REGEX = Pattern.quote("/");
    private final InstallerPackageNameProvider installerPackageNameProvider;
    private final Context appContext;
    private final String appIdentifier;
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    private final DataCollectionArbiter dataCollectionArbiter;
    private String crashlyticsInstallId;

    public IdManager(Context appContext, String appIdentifier, FirebaseInstallationsApi firebaseInstallationsApi, DataCollectionArbiter dataCollectionArbiter) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext must not be null");
        }
        if (appIdentifier == null) {
            throw new IllegalArgumentException("appIdentifier must not be null");
        }
        this.appContext = appContext;
        this.appIdentifier = appIdentifier;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.installerPackageNameProvider = new InstallerPackageNameProvider();
    }

    private static String formatId(String id) {
        return id == null ? null : ID_PATTERN.matcher(id).replaceAll("").toLowerCase(Locale.US);
    }

    @Override
    @NonNull
    public synchronized String getCrashlyticsInstallId() {
        if (this.crashlyticsInstallId != null) {
            return this.crashlyticsInstallId;
        }
        Logger.getLogger().v("Determining Crashlytics installation ID...");
        SharedPreferences prefs = CommonUtils.getSharedPrefs(this.appContext);
        String cachedFid = prefs.getString(PREFKEY_FIREBASE_IID, null);
        Logger.getLogger().v("Cached Firebase Installation ID: " + cachedFid);
        if (this.dataCollectionArbiter.isAutomaticDataCollectionEnabled()) {
            String trueFid = this.fetchTrueFid();
            Logger.getLogger().v("Fetched Firebase Installation ID: " + trueFid);
            if (trueFid == null) {
                String string = trueFid = cachedFid == null ? IdManager.createSyntheticFid() : cachedFid;
            }
            this.crashlyticsInstallId = trueFid.equals(cachedFid) ? this.readCachedCrashlyticsInstallId(prefs) : this.createAndCacheCrashlyticsInstallId(trueFid, prefs);
        } else {
            this.crashlyticsInstallId = IdManager.isSyntheticFid(cachedFid) ? this.readCachedCrashlyticsInstallId(prefs) : this.createAndCacheCrashlyticsInstallId(IdManager.createSyntheticFid(), prefs);
        }
        if (this.crashlyticsInstallId == null) {
            Logger.getLogger().w("Unable to determine Crashlytics Install Id, creating a new one.");
            this.crashlyticsInstallId = this.createAndCacheCrashlyticsInstallId(IdManager.createSyntheticFid(), prefs);
        }
        Logger.getLogger().v("Crashlytics installation ID: " + this.crashlyticsInstallId);
        return this.crashlyticsInstallId;
    }

    static String createSyntheticFid() {
        return SYNTHETIC_FID_PREFIX + UUID.randomUUID().toString();
    }

    static boolean isSyntheticFid(String fid) {
        return fid != null && fid.startsWith(SYNTHETIC_FID_PREFIX);
    }

    private String readCachedCrashlyticsInstallId(SharedPreferences prefs) {
        return prefs.getString("crashlytics.installation.id", null);
    }

    @Nullable
    private String fetchTrueFid() {
        Task currentFidTask = this.firebaseInstallationsApi.getId();
        String currentFid = null;
        try {
            currentFid = (String)Utils.awaitEvenIfOnMainThread(currentFidTask);
        }
        catch (Exception e) {
            Logger.getLogger().w("Failed to retrieve Firebase Installations ID.", e);
        }
        return currentFid;
    }

    @NonNull
    private synchronized String createAndCacheCrashlyticsInstallId(String fidToCache, SharedPreferences prefs) {
        String iid = IdManager.formatId(UUID.randomUUID().toString());
        Logger.getLogger().v("Created new Crashlytics installation ID: " + iid + " for FID: " + fidToCache);
        prefs.edit().putString("crashlytics.installation.id", iid).putString(PREFKEY_FIREBASE_IID, fidToCache).apply();
        return iid;
    }

    public String getAppIdentifier() {
        return this.appIdentifier;
    }

    public String getOsDisplayVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.RELEASE);
    }

    public String getOsBuildVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.INCREMENTAL);
    }

    public String getModelName() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.MANUFACTURER), this.removeForwardSlashesIn(Build.MODEL));
    }

    private String removeForwardSlashesIn(String s) {
        return s.replaceAll(FORWARD_SLASH_REGEX, "");
    }

    public String getInstallerPackageName() {
        return this.installerPackageNameProvider.getInstallerPackageName(this.appContext);
    }
}

