/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model.serialization;

import android.util.Base64;
import android.util.JsonReader;
import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.model.AutoCrashlyticsReportEncoder;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class CrashlyticsReportJsonTransform {
    private static final DataEncoder CRASHLYTICS_REPORT_JSON_ENCODER = new JsonDataEncoderBuilder().configureWith(AutoCrashlyticsReportEncoder.CONFIG).ignoreNullValues(true).build();

    @NonNull
    public String reportToJson(@NonNull CrashlyticsReport report) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode((Object)report);
    }

    @NonNull
    public String eventToJson(@NonNull CrashlyticsReport.Session.Event event) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode((Object)event);
    }

    @NonNull
    public String applicationExitInfoToJson(@NonNull CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode((Object)applicationExitInfo);
    }

    @NonNull
    public CrashlyticsReport reportFromJson(@NonNull String json) throws IOException {
        CrashlyticsReport crashlyticsReport;
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
        try {
            crashlyticsReport = CrashlyticsReportJsonTransform.parseReport(jsonReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new IOException(e);
            }
        }
        jsonReader.close();
        return crashlyticsReport;
    }

    @NonNull
    public CrashlyticsReport.Session.Event eventFromJson(@NonNull String json) throws IOException {
        CrashlyticsReport.Session.Event event;
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
        try {
            event = CrashlyticsReportJsonTransform.parseEvent(jsonReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new IOException(e);
            }
        }
        jsonReader.close();
        return event;
    }

    @NonNull
    public CrashlyticsReport.ApplicationExitInfo applicationExitInfoFromJson(@NonNull String json) throws IOException {
        CrashlyticsReport.ApplicationExitInfo applicationExitInfo;
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
        try {
            applicationExitInfo = CrashlyticsReportJsonTransform.parseAppExitInfo(jsonReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new IOException(e);
            }
        }
        jsonReader.close();
        return applicationExitInfo;
    }

    @NonNull
    private static CrashlyticsReport parseReport(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Builder builder = CrashlyticsReport.builder();
        jsonReader.beginObject();
        block20: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "sdkVersion": {
                    builder.setSdkVersion(jsonReader.nextString());
                    continue block20;
                }
                case "gmpAppId": {
                    builder.setGmpAppId(jsonReader.nextString());
                    continue block20;
                }
                case "platform": {
                    builder.setPlatform(jsonReader.nextInt());
                    continue block20;
                }
                case "installationUuid": {
                    builder.setInstallationUuid(jsonReader.nextString());
                    continue block20;
                }
                case "buildVersion": {
                    builder.setBuildVersion(jsonReader.nextString());
                    continue block20;
                }
                case "displayVersion": {
                    builder.setDisplayVersion(jsonReader.nextString());
                    continue block20;
                }
                case "session": {
                    builder.setSession(CrashlyticsReportJsonTransform.parseSession(jsonReader));
                    continue block20;
                }
                case "ndkPayload": {
                    builder.setNdkPayload(CrashlyticsReportJsonTransform.parseNdkPayload(jsonReader));
                    continue block20;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session parseSession(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Builder builder = CrashlyticsReport.Session.builder();
        jsonReader.beginObject();
        block26: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "generator": {
                    builder.setGenerator(jsonReader.nextString());
                    continue block26;
                }
                case "identifier": {
                    builder.setIdentifierFromUtf8Bytes(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block26;
                }
                case "startedAt": {
                    builder.setStartedAt(jsonReader.nextLong());
                    continue block26;
                }
                case "endedAt": {
                    builder.setEndedAt(jsonReader.nextLong());
                    continue block26;
                }
                case "crashed": {
                    builder.setCrashed(jsonReader.nextBoolean());
                    continue block26;
                }
                case "user": {
                    builder.setUser(CrashlyticsReportJsonTransform.parseUser(jsonReader));
                    continue block26;
                }
                case "app": {
                    builder.setApp(CrashlyticsReportJsonTransform.parseApp(jsonReader));
                    continue block26;
                }
                case "os": {
                    builder.setOs(CrashlyticsReportJsonTransform.parseOs(jsonReader));
                    continue block26;
                }
                case "device": {
                    builder.setDevice(CrashlyticsReportJsonTransform.parseDevice(jsonReader));
                    continue block26;
                }
                case "events": {
                    builder.setEvents(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseEvent));
                    continue block26;
                }
                case "generatorType": {
                    builder.setGeneratorType(jsonReader.nextInt());
                    continue block26;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.FilesPayload parseNdkPayload(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.FilesPayload.Builder builder = CrashlyticsReport.FilesPayload.builder();
        jsonReader.beginObject();
        block8: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "files": {
                    builder.setFiles(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseFile));
                    continue block8;
                }
                case "orgId": {
                    builder.setOrgId(jsonReader.nextString());
                    continue block8;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.ApplicationExitInfo parseAppExitInfo(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.ApplicationExitInfo.Builder builder = CrashlyticsReport.ApplicationExitInfo.builder();
        jsonReader.beginObject();
        block22: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "pid": {
                    builder.setPid(jsonReader.nextInt());
                    continue block22;
                }
                case "processName": {
                    builder.setProcessName(jsonReader.nextString());
                    continue block22;
                }
                case "reasonCode": {
                    builder.setReasonCode(jsonReader.nextInt());
                    continue block22;
                }
                case "importance": {
                    builder.setImportance(jsonReader.nextInt());
                    continue block22;
                }
                case "pss": {
                    builder.setPss(jsonReader.nextLong());
                    continue block22;
                }
                case "rss": {
                    builder.setRss(jsonReader.nextLong());
                    continue block22;
                }
                case "timestamp": {
                    builder.setTimestamp(jsonReader.nextLong());
                    continue block22;
                }
                case "traceFile": {
                    builder.setTraceFile(jsonReader.nextString());
                    continue block22;
                }
                case "buildIdMappingForArch": {
                    builder.setBuildIdMappingForArch(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseBuildIdMappingForArch));
                    continue block22;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.FilesPayload.File parseFile(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.FilesPayload.File.Builder builder = CrashlyticsReport.FilesPayload.File.builder();
        jsonReader.beginObject();
        block8: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "filename": {
                    builder.setFilename(jsonReader.nextString());
                    continue block8;
                }
                case "contents": {
                    builder.setContents(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block8;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.User parseUser(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.User.Builder builder = CrashlyticsReport.Session.User.builder();
        jsonReader.beginObject();
        block6: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "identifier": {
                    builder.setIdentifier(jsonReader.nextString());
                    continue block6;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Application parseApp(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Application.Builder builder = CrashlyticsReport.Session.Application.builder();
        jsonReader.beginObject();
        block16: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "identifier": {
                    builder.setIdentifier(jsonReader.nextString());
                    continue block16;
                }
                case "version": {
                    builder.setVersion(jsonReader.nextString());
                    continue block16;
                }
                case "displayVersion": {
                    builder.setDisplayVersion(jsonReader.nextString());
                    continue block16;
                }
                case "installationUuid": {
                    builder.setInstallationUuid(jsonReader.nextString());
                    continue block16;
                }
                case "developmentPlatform": {
                    builder.setDevelopmentPlatform(jsonReader.nextString());
                    continue block16;
                }
                case "developmentPlatformVersion": {
                    builder.setDevelopmentPlatformVersion(jsonReader.nextString());
                    continue block16;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.OperatingSystem parseOs(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.OperatingSystem.Builder builder = CrashlyticsReport.Session.OperatingSystem.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "platform": {
                    builder.setPlatform(jsonReader.nextInt());
                    continue block12;
                }
                case "version": {
                    builder.setVersion(jsonReader.nextString());
                    continue block12;
                }
                case "buildVersion": {
                    builder.setBuildVersion(jsonReader.nextString());
                    continue block12;
                }
                case "jailbroken": {
                    builder.setJailbroken(jsonReader.nextBoolean());
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Device parseDevice(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Device.Builder builder = CrashlyticsReport.Session.Device.builder();
        jsonReader.beginObject();
        block22: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "arch": {
                    builder.setArch(jsonReader.nextInt());
                    continue block22;
                }
                case "model": {
                    builder.setModel(jsonReader.nextString());
                    continue block22;
                }
                case "cores": {
                    builder.setCores(jsonReader.nextInt());
                    continue block22;
                }
                case "ram": {
                    builder.setRam(jsonReader.nextLong());
                    continue block22;
                }
                case "diskSpace": {
                    builder.setDiskSpace(jsonReader.nextLong());
                    continue block22;
                }
                case "simulator": {
                    builder.setSimulator(jsonReader.nextBoolean());
                    continue block22;
                }
                case "state": {
                    builder.setState(jsonReader.nextInt());
                    continue block22;
                }
                case "manufacturer": {
                    builder.setManufacturer(jsonReader.nextString());
                    continue block22;
                }
                case "modelClass": {
                    builder.setModelClass(jsonReader.nextString());
                    continue block22;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event parseEvent(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Builder builder = CrashlyticsReport.Session.Event.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "timestamp": {
                    builder.setTimestamp(jsonReader.nextLong());
                    continue block14;
                }
                case "type": {
                    builder.setType(jsonReader.nextString());
                    continue block14;
                }
                case "app": {
                    builder.setApp(CrashlyticsReportJsonTransform.parseEventApp(jsonReader));
                    continue block14;
                }
                case "device": {
                    builder.setDevice(CrashlyticsReportJsonTransform.parseEventDevice(jsonReader));
                    continue block14;
                }
                case "log": {
                    builder.setLog(CrashlyticsReportJsonTransform.parseEventLog(jsonReader));
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application parseEventApp(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Builder builder = CrashlyticsReport.Session.Event.Application.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "background": {
                    builder.setBackground(jsonReader.nextBoolean());
                    continue block14;
                }
                case "uiOrientation": {
                    builder.setUiOrientation(jsonReader.nextInt());
                    continue block14;
                }
                case "execution": {
                    builder.setExecution(CrashlyticsReportJsonTransform.parseEventExecution(jsonReader));
                    continue block14;
                }
                case "customAttributes": {
                    builder.setCustomAttributes(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseCustomAttribute));
                    continue block14;
                }
                case "internalKeys": {
                    builder.setInternalKeys(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseCustomAttribute));
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application.Execution parseEventExecution(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "threads": {
                    builder.setThreads(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseEventThread));
                    continue block14;
                }
                case "exception": {
                    builder.setException(CrashlyticsReportJsonTransform.parseEventExecutionException(jsonReader));
                    continue block14;
                }
                case "signal": {
                    builder.setSignal(CrashlyticsReportJsonTransform.parseEventSignal(jsonReader));
                    continue block14;
                }
                case "binaries": {
                    builder.setBinaries(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseEventBinaryImage));
                    continue block14;
                }
                case "appExitInfo": {
                    builder.setAppExitInfo(CrashlyticsReportJsonTransform.parseAppExitInfo(jsonReader));
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application.Execution.Exception parseEventExecutionException(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Exception.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Exception.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "causedBy": {
                    builder.setCausedBy(CrashlyticsReportJsonTransform.parseEventExecutionException(jsonReader));
                    continue block14;
                }
                case "frames": {
                    builder.setFrames(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseEventFrame));
                    continue block14;
                }
                case "overflowCount": {
                    builder.setOverflowCount(jsonReader.nextInt());
                    continue block14;
                }
                case "type": {
                    builder.setType(jsonReader.nextString());
                    continue block14;
                }
                case "reason": {
                    builder.setReason(jsonReader.nextString());
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application.Execution.Signal parseEventSignal(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Signal.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Signal.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "name": {
                    builder.setName(jsonReader.nextString());
                    continue block10;
                }
                case "code": {
                    builder.setCode(jsonReader.nextString());
                    continue block10;
                }
                case "address": {
                    builder.setAddress(jsonReader.nextLong());
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application.Execution.BinaryImage parseEventBinaryImage(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "name": {
                    builder.setName(jsonReader.nextString());
                    continue block12;
                }
                case "baseAddress": {
                    builder.setBaseAddress(jsonReader.nextLong());
                    continue block12;
                }
                case "size": {
                    builder.setSize(jsonReader.nextLong());
                    continue block12;
                }
                case "uuid": {
                    builder.setUuidFromUtf8Bytes(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block12;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application.Execution.Thread parseEventThread(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Thread.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Thread.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "importance": {
                    builder.setImportance(jsonReader.nextInt());
                    continue block10;
                }
                case "name": {
                    builder.setName(jsonReader.nextString());
                    continue block10;
                }
                case "frames": {
                    builder.setFrames(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform::parseEventFrame));
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame parseEventFrame(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "importance": {
                    builder.setImportance(jsonReader.nextInt());
                    continue block14;
                }
                case "file": {
                    builder.setFile(jsonReader.nextString());
                    continue block14;
                }
                case "offset": {
                    builder.setOffset(jsonReader.nextLong());
                    continue block14;
                }
                case "pc": {
                    builder.setPc(jsonReader.nextLong());
                    continue block14;
                }
                case "symbol": {
                    builder.setSymbol(jsonReader.nextString());
                    continue block14;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Device parseEventDevice(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Device.Builder builder = CrashlyticsReport.Session.Event.Device.builder();
        jsonReader.beginObject();
        block16: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "batteryLevel": {
                    builder.setBatteryLevel(jsonReader.nextDouble());
                    continue block16;
                }
                case "batteryVelocity": {
                    builder.setBatteryVelocity(jsonReader.nextInt());
                    continue block16;
                }
                case "diskUsed": {
                    builder.setDiskUsed(jsonReader.nextLong());
                    continue block16;
                }
                case "proximityOn": {
                    builder.setProximityOn(jsonReader.nextBoolean());
                    continue block16;
                }
                case "orientation": {
                    builder.setOrientation(jsonReader.nextInt());
                    continue block16;
                }
                case "ramUsed": {
                    builder.setRamUsed(jsonReader.nextLong());
                    continue block16;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.Session.Event.Log parseEventLog(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Log.Builder builder = CrashlyticsReport.Session.Event.Log.builder();
        jsonReader.beginObject();
        block6: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "content": {
                    builder.setContent(jsonReader.nextString());
                    continue block6;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.CustomAttribute parseCustomAttribute(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.CustomAttribute.Builder builder = CrashlyticsReport.CustomAttribute.builder();
        jsonReader.beginObject();
        block8: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "key": {
                    builder.setKey(jsonReader.nextString());
                    continue block8;
                }
                case "value": {
                    builder.setValue(jsonReader.nextString());
                    continue block8;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch parseBuildIdMappingForArch(@NonNull JsonReader jsonReader) throws IOException {
        CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch.Builder builder = CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "libraryName": {
                    builder.setLibraryName(jsonReader.nextString());
                    continue block10;
                }
                case "arch": {
                    builder.setArch(jsonReader.nextString());
                    continue block10;
                }
                case "buildId": {
                    builder.setBuildId(jsonReader.nextString());
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    @NonNull
    private static <T> ImmutableList<T> parseArray(@NonNull JsonReader jsonReader, @NonNull ObjectParser<T> objectParser) throws IOException {
        ArrayList<T> objects = new ArrayList<T>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            objects.add(objectParser.parse(jsonReader));
        }
        jsonReader.endArray();
        return ImmutableList.from(objects);
    }

    private static interface ObjectParser<T> {
        public T parse(@NonNull JsonReader var1) throws IOException;
    }
}

