/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.settings.Settings;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonTransform;
import org.json.JSONObject;

class DefaultSettingsJsonTransform
implements SettingsJsonTransform {
    DefaultSettingsJsonTransform() {
    }

    @Override
    public Settings buildFromJson(CurrentTimeProvider currentTimeProvider, JSONObject json) {
        return DefaultSettingsJsonTransform.defaultSettings(currentTimeProvider);
    }

    static Settings defaultSettings(CurrentTimeProvider currentTimeProvider) {
        int settingsVersion = 0;
        int cacheDurationSeconds = 3600;
        double onDemandUploadRatePerMinute = 10.0;
        double onDemandBackoffBase = 1.2;
        int onDemandBackoffStepDurationSeconds = 60;
        Settings.SessionData sessionData = new Settings.SessionData(8, 4);
        Settings.FeatureFlagData featureFlagData = new Settings.FeatureFlagData(true, false);
        long expiresAtMillis = currentTimeProvider.getCurrentTimeMillis() + (long)(cacheDurationSeconds * 1000);
        return new Settings(expiresAtMillis, sessionData, featureFlagData, settingsVersion, cacheDurationSeconds, onDemandUploadRatePerMinute, onDemandBackoffBase, onDemandBackoffStepDurationSeconds);
    }
}

