/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.analytics;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbHandler;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import org.json.JSONException;
import org.json.JSONObject;

public class BreadcrumbAnalyticsEventReceiver
implements AnalyticsEventReceiver,
BreadcrumbSource {
    private static final String BREADCRUMB_NAME_KEY = "name";
    private static final String BREADCRUMB_PARAMS_KEY = "parameters";
    private static final String BREADCRUMB_PREFIX = "$A$:";
    @Nullable
    private BreadcrumbHandler breadcrumbHandler;

    @Override
    public void onEvent(@NonNull String name, @NonNull Bundle params) {
        BreadcrumbHandler receiver = this.breadcrumbHandler;
        if (receiver != null) {
            try {
                String serializedEvent = BREADCRUMB_PREFIX + BreadcrumbAnalyticsEventReceiver.serializeEvent(name, params);
                receiver.handleBreadcrumb(serializedEvent);
            }
            catch (JSONException e) {
                Logger.getLogger().w("Unable to serialize Firebase Analytics event to breadcrumb.");
            }
        }
    }

    @Override
    public void registerBreadcrumbHandler(@Nullable BreadcrumbHandler breadcrumbHandler) {
        this.breadcrumbHandler = breadcrumbHandler;
        Logger.getLogger().d("Registered Firebase Analytics event receiver for breadcrumbs");
    }

    @NonNull
    private static String serializeEvent(@NonNull String name, @NonNull Bundle params) throws JSONException {
        JSONObject enclosingObject = new JSONObject();
        JSONObject paramsObject = new JSONObject();
        for (String key : params.keySet()) {
            paramsObject.put(key, params.get(key));
        }
        enclosingObject.put(BREADCRUMB_NAME_KEY, (Object)name);
        enclosingObject.put(BREADCRUMB_PARAMS_KEY, (Object)paramsObject);
        return enclosingObject.toString();
    }
}

