/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.util.Log;

public class Logger {
    public static final String TAG = "FirebaseCrashlytics";
    static final Logger DEFAULT_LOGGER = new Logger("FirebaseCrashlytics");
    private final String tag;
    private int logLevel;

    public Logger(String tag) {
        this.tag = tag;
        this.logLevel = 4;
    }

    public static Logger getLogger() {
        return DEFAULT_LOGGER;
    }

    private boolean canLog(int level) {
        return this.logLevel <= level || Log.isLoggable((String)this.tag, (int)level);
    }

    public void d(String text, Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void v(String text, Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void i(String text, Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void w(String text, Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void e(String text, Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void d(String text) {
        this.d(text, null);
    }

    public void v(String text) {
        this.v(text, null);
    }

    public void i(String text) {
        this.i(text, null);
    }

    public void w(String text) {
        this.w(text, null);
    }

    public void e(String text) {
        this.e(text, null);
    }

    public void log(int priority, String msg) {
        this.log(priority, msg, false);
    }

    public void log(int priority, String msg, boolean forceLog) {
        if (forceLog || this.canLog(priority)) {
            Log.println((int)priority, (String)this.tag, (String)msg);
        }
    }
}

